require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.mongo.MongoGridFsClient
module VertxMongo
  class MongoGridFsClient
    # @private
    # @param j_del [::VertxMongo::MongoGridFsClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMongo::MongoGridFsClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MongoGridFsClient
    end
    def @@j_api_type.wrap(obj)
      MongoGridFsClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtMongo::MongoGridFsClient.java_class
    end
    #  Drops the entire file bucket with all of its contents
    # @overload drop(resultHandler)
    #   @yield called when the bucket is dropped
    # @return [self]
    def drop
      if true
        if (block_given?)
          @j_del.java_method(:drop, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:drop, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling drop()"
      end
    end
    #  Upload a file to gridfs
    # @overload uploadFile(fileName,resultHandler)
    #   @param [String] fileName the name of the file to store in gridfs
    #   @yield the id of the file that was uploaded
    # @return [self]
    def upload_file(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:uploadFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:uploadFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling upload_file(#{args[0]})"
      end
    end
    # @overload downloadByFileName(stream,fileName,resultHandler)
    #   @param [::Vertx::WriteStream] stream 
    #   @param [String] fileName 
    #   @yield 
    # @return [self]
    def download_by_file_name(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:downloadByFileName, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:downloadByFileName, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling download_by_file_name(#{args[0]},#{args[1]})"
      end
    end
    #  Finds all file ids in the bucket
    # @overload findAllIds(resultHandler)
    #   @yield called when the list of file ids is available
    # @return [self]
    def find_all_ids
      if true
        if (block_given?)
          @j_del.java_method(:findAllIds, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findAllIds, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_all_ids()"
      end
    end
    # @overload uploadByFileNameWithOptions(stream,fileName,options,resultHandler)
    #   @param [::Vertx::ReadStream] stream 
    #   @param [String] fileName 
    #   @param [Hash{String => Object}] options 
    #   @yield 
    # @return [self]
    def upload_by_file_name_with_options(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:uploadByFileNameWithOptions, [Java::IoVertxCoreStreams::ReadStream.java_class,Java::java.lang.String.java_class,Java::IoVertxExtMongo::GridFsUploadOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],Java::IoVertxExtMongo::GridFsUploadOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:uploadByFileNameWithOptions, [Java::IoVertxCoreStreams::ReadStream.java_class,Java::java.lang.String.java_class,Java::IoVertxExtMongo::GridFsUploadOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],Java::IoVertxExtMongo::GridFsUploadOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling upload_by_file_name_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    # @overload uploadByFileName(stream,fileName,resultHandler)
    #   @param [::Vertx::ReadStream] stream 
    #   @param [String] fileName 
    #   @yield 
    # @return [self]
    def upload_by_file_name(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:uploadByFileName, [Java::IoVertxCoreStreams::ReadStream.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:uploadByFileName, [Java::IoVertxCoreStreams::ReadStream.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling upload_by_file_name(#{args[0]},#{args[1]})"
      end
    end
    # @overload downloadById(stream,id,resultHandler)
    #   @param [::Vertx::WriteStream] stream 
    #   @param [String] id 
    #   @yield 
    # @return [self]
    def download_by_id(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:downloadById, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:downloadById, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling download_by_id(#{args[0]},#{args[1]})"
      end
    end
    #  Upload a file to gridfs with options
    # @overload uploadFileWithOptions(fileName,options,resultHandler)
    #   @param [String] fileName the name of the file to store in gridfs
    #   @param [Hash{String => Object}] options {Hash{String => Object}} for specifying metadata and chunk size
    #   @yield the id of the file that was uploaded
    # @return [self]
    def upload_file_with_options(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:uploadFileWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtMongo::GridFsUploadOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtMongo::GridFsUploadOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:uploadFileWithOptions, [Java::java.lang.String.java_class,Java::IoVertxExtMongo::GridFsUploadOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxExtMongo::GridFsUploadOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling upload_file_with_options(#{args[0]},#{args[1]})"
      end
    end
    #  Deletes a file by it's ID
    # @overload delete(id,resultHandler)
    #   @param [String] id the identifier of the file
    #   @yield will be called when the file is deleted
    # @return [self]
    def delete(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete(#{args[0]})"
      end
    end
    #  Downloads a file.
    # @overload downloadFile(fileName,resultHandler)
    #   @param [String] fileName the name of the file to download
    #   @yield called when the file is downloaded and returns the length in bytes
    # @return [self]
    def download_file(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:downloadFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:downloadFile, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling download_file(#{args[0]})"
      end
    end
    #  Downloads a file and gives it a new name.
    # @overload downloadFileAs(fileName,newFileName,resultHandler)
    #   @param [String] fileName the name of the file to download
    #   @param [String] newFileName the name the file should be saved as
    #   @yield called when the file is downloaded and returns the length in bytes
    # @return [self]
    def download_file_as(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:downloadFileAs, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:downloadFileAs, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling download_file_as(#{args[0]},#{args[1]})"
      end
    end
    # @overload downloadByFileNameWithOptions(stream,fileName,options,resultHandler)
    #   @param [::Vertx::WriteStream] stream 
    #   @param [String] fileName 
    #   @param [Hash{String => Object}] options 
    #   @yield 
    # @return [self]
    def download_by_file_name_with_options(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:downloadByFileNameWithOptions, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::java.lang.String.java_class,Java::IoVertxExtMongo::GridFsDownloadOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],Java::IoVertxExtMongo::GridFsDownloadOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:downloadByFileNameWithOptions, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::java.lang.String.java_class,Java::IoVertxExtMongo::GridFsDownloadOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],Java::IoVertxExtMongo::GridFsDownloadOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling download_by_file_name_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Finds all file ids that match a query.
    # @overload findIds(query,resultHandler)
    #   @param [Hash{String => Object}] query a bson query expressed as json that will be used to match files
    #   @yield called when the list of file ids is available
    # @return [self]
    def find_ids(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findIds, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findIds, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_ids(#{args[0]})"
      end
    end
    #  Close the client and release its resources
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Downloads a file using the ID generated by GridFs.
    # @overload downloadFileByID(id,fileName,resultHandler)
    #   @param [String] id the GridFs Object ID of the file to download
    #   @param [String] fileName 
    #   @yield called when the file is downloaded and returns the length in bytes
    # @return [self]
    def download_file_by_id(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:downloadFileByID, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:downloadFileByID, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling download_file_by_id(#{args[0]},#{args[1]})"
      end
    end
  end
end
