require 'vertx/pipe'
require 'vertx-rabbitmq/rabbit_mq_message'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.rabbitmq.RabbitMQConsumer
module VertxRabbitmq
  #  A stream of messages from a rabbitmq queue.
  class RabbitMQConsumer
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxRabbitmq::RabbitMQConsumer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRabbitmq::RabbitMQConsumer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RabbitMQConsumer
    end
    def @@j_api_type.wrap(obj)
      RabbitMQConsumer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRabbitmq::RabbitMQConsumer.java_class
    end
    #  Stop message consumption from a queue.
    #  <p>
    #  The operation is asynchronous. When consumption will be stopped, you can by notified via {::VertxRabbitmq::RabbitMQConsumer#end_handler}
    # @overload cancel()
    # @overload cancel(cancelResult)
    #   @yield contains information about operation status: success/fail.
    # @return [void]
    def cancel
      if !block_given?
        return @j_del.java_method(:cancel, []).call()
      elsif true
        if (block_given?)
          return @j_del.java_method(:cancel, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:cancel, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cancel()"
      end
    end
    #  Resume reading from a queue. Flushes internal queue.
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    # @overload isPaused()
    # @return [true,false] is the stream paused?
    def paused?
      if !block_given?
        return @j_del.java_method(:isPaused, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling paused?()"
      end
    end
    # @overload consumerTag()
    # @return [String] a consumer tag
    def consumer_tag
      if !block_given?
        return @j_del.java_method(:consumerTag, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling consumer_tag()"
      end
    end
    #  Set a message handler. As message appear in a queue, the handler will be called with the message.
    # @overload handler(messageArrived)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxRabbitmq::RabbitMQMessage)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    #  Set an end handler. Once the stream has canceled successfully, the handler will be called.
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    #  Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
    #  recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
    #  be added to the current stream demand.
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::VertxRabbitmq::RabbitMQMessage.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    #  Set an exception handler on the read stream.
    # @overload exceptionHandler(exceptionHandler)
    #   @yield the exception handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Pause the stream of incoming messages from queue.
    #  <p>
    #  The messages will continue to arrive, but they will be stored in a internal queue.
    #  If the queue size would exceed the limit provided by , then incoming messages will be discarded.
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
  end
end
