require 'vertx/vertx'
require 'vertx-redis/redis_connection'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.Redis
module VertxRedis
  #  A simple Redis client.
  class Redis
    # @private
    # @param j_del [::VertxRedis::Redis] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::Redis] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Redis
    end
    def @@j_api_type.wrap(obj)
      Redis.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::Redis.java_class
    end
    #  Create a new redis client using the given client options.
    # @overload createClient(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @overload createClient(vertx,endpoint)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [String] endpoint the server address to connect to
    # @overload createClient(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the user provided options
    # @return [::VertxRedis::Redis] the client
    def self.create_client(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Redis.java_method(:createClient, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxRedis::Redis)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Redis.java_method(:createClient, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxRedis::Redis)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Redis.java_method(:createClient, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxRedisClient::RedisOptions.java_class]).call(args[0].j_del,Java::IoVertxRedisClient::RedisOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxRedis::Redis)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_client(#{args[0]},#{args[1]})"
      end
    end
    #  Closes the client and terminates any connection.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Connects to the redis server.
    # @overload connect(handler)
    #   @yield the async result handler
    # @return [self]
    def connect
      if true
        if (block_given?)
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::RedisConnection) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::RedisConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRedis::RedisConnection.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect()"
      end
    end
  end
end
