require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.session.Session
module VertxShell
  #  A shell session.
  class Session
    # @private
    # @param j_del [::VertxShell::Session] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::Session] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Session
    end
    def @@j_api_type.wrap(obj)
      Session.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellSession::Session.java_class
    end
    #  Get some data from the session
    # @overload get(key)
    #   @param [String] key the key of the data
    # @return [Object] the data
    def get(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  Create a new empty session.
    # @overload create()
    # @return [::VertxShell::Session] the created session
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellSession::Session.java_method(:create, []).call(),::VertxShell::Session)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
    #  Remove some data from the session
    # @overload remove(key)
    #   @param [String] key the key of the data
    # @return [Object] the data that was there or null if none there
    def remove(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:remove, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove(#{args[0]})"
      end
    end
    #  Put some data in a session
    # @overload put(key,obj)
    #   @param [String] key the key for the data
    #   @param [Object] obj the data
    # @return [self]
    def put(*args)
      if args[0].class == String && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given?
        @j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(args[0],::Vertx::Util::Utils.to_object(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]})"
      end
    end
  end
end
