require 'vertx-sql-client/row_stream'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/cursor'
require 'vertx-sql-client/tuple'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.PreparedQuery
module VertxSqlClient
  #  A prepared query.
  class PreparedQuery
    # @private
    # @param j_del [::VertxSqlClient::PreparedQuery] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::PreparedQuery] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PreparedQuery
    end
    def @@j_api_type.wrap(obj)
      PreparedQuery.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::PreparedQuery.java_class
    end
    #  Create a cursor with the provided <code>arguments</code>.
    # @overload cursor()
    # @overload cursor(args)
    #   @param [::VertxSqlClient::Tuple] args the list of arguments
    # @return [::VertxSqlClient::Cursor] the query
    def cursor(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cursor, []).call(),::VertxSqlClient::Cursor)
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cursor, [Java::IoVertxSqlclient::Tuple.java_class]).call(args[0].j_del),::VertxSqlClient::Cursor)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cursor(#{args[0]})"
      end
    end
    #  Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
    #  with a <code>fetch</code> size to fetch the results.
    #  <p/>
    #  Note: this requires to be in a transaction, since cursors require it.
    # @overload createStream(fetch,args)
    #   @param [Fixnum] fetch the cursor fetch size
    #   @param [::VertxSqlClient::Tuple] args the prepared query arguments
    # @return [::VertxSqlClient::RowStream] the createStream
    def create_stream(*args)
      if args[0].class == Fixnum && args[1].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createStream, [Java::int.java_class,Java::IoVertxSqlclient::Tuple.java_class]).call(args[0],args[1].j_del),::VertxSqlClient::RowStream,::VertxSqlClient::Row.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_stream(#{args[0]},#{args[1]})"
      end
    end
    #  Execute a batch.
    # @overload batch(argsList,handler)
    #   @param [Array<::VertxSqlClient::Tuple>] argsList the list of tuple for the batch
    #   @yield 
    # @return [self]
    def batch(*args)
      if args[0].class == Array && true
        if (block_given?)
          @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling batch(#{args[0]})"
      end
    end
    #  Like {::VertxSqlClient::PreparedQuery#close} but notifies the <code>completionHandler</code> when it's closed.
    # @overload close()
    # @overload close(completionHandler)
    #   @yield 
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Create a cursor with the provided <code>arguments</code>.
    # @overload execute(handler)
    #   @yield 
    # @overload execute(args,handler)
    #   @param [::VertxSqlClient::Tuple] args the list of arguments
    #   @yield 
    # @return [self]
    def execute(*args)
      if true && args[0] == nil
        if (block_given?)
          @j_del.java_method(:execute, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:execute, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:execute, [Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:execute, [Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute(#{args[0]})"
      end
    end
  end
end
