require 'vertx-web-client/http_response'
require 'vertx/buffer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.client.predicate.ResponsePredicateResult
module VertxWebClient
  #  Represents the outcome of a {::VertxWebClient::ResponsePredicate} applied to an .
  class ResponsePredicateResult
    # @private
    # @param j_del [::VertxWebClient::ResponsePredicateResult] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebClient::ResponsePredicateResult] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ResponsePredicateResult
    end
    def @@j_api_type.wrap(obj)
      ResponsePredicateResult.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebClientPredicate::ResponsePredicateResult.java_class
    end
    #  The  which has been tested.
    # @overload response()
    # @return [::VertxWebClient::HttpResponse] <code>null</code> after the result has been created, or the tested response for converters created with {::VertxWebClient::ErrorConverter#create_full_body}
    def response
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:response, []).call(),::VertxWebClient::HttpResponse,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling response()"
      end
    end
    #  Creates a failed result.
    # @overload failure(message)
    #   @param [String] message the failure description
    # @return [::VertxWebClient::ResponsePredicateResult]
    def self.failure(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicateResult.java_method(:failure, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebClient::ResponsePredicateResult)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling failure(#{args[0]})"
      end
    end
    # @overload success()
    # @return [::VertxWebClient::ResponsePredicateResult] a successful result
    def self.success
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ResponsePredicateResult.java_method(:success, []).call(),::VertxWebClient::ResponsePredicateResult)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling success()"
      end
    end
    #  The failure message. May be <code>null</code>.
    # @overload message()
    # @return [String]
    def message
      if !block_given?
        return @j_del.java_method(:message, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling message()"
      end
    end
    #  Whether the result is a success or failure.
    # @overload succeeded()
    # @return [true,false] <code>true</code> if the {::VertxWebClient::ResponsePredicate} was applied successfully, false otherwise
    def succeeded?
      if !block_given?
        return @j_del.java_method(:succeeded, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling succeeded?()"
      end
    end
  end
end
