require 'vertx-web-common/template_engine'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine
module VertxWebTemplThymeleaf
  #  A template engine that uses the Thymeleaf library.
  class ThymeleafTemplateEngine < ::VertxWebCommon::TemplateEngine
    # @private
    # @param j_del [::VertxWebTemplThymeleaf::ThymeleafTemplateEngine] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebTemplThymeleaf::ThymeleafTemplateEngine] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ThymeleafTemplateEngine
    end
    def @@j_api_type.wrap(obj)
      ThymeleafTemplateEngine.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebTemplThymeleaf::ThymeleafTemplateEngine.java_class
    end
    #  Set the mode for the engine
    # @overload setMode(mode)
    #   @param [:HTML,:XML,:TEXT,:JAVASCRIPT,:CSS,:RAW,:HTML5,:LEGACYHTML5,:XHTML,:VALIDXHTML,:VALIDXML] mode the mode
    # @return [self]
    def set_mode(*args)
      if args[0].class == Symbol && !block_given?
        @j_del.java_method(:setMode, [Java::OrgThymeleafTemplatemode::TemplateMode.java_class]).call(Java::OrgThymeleafTemplatemode::TemplateMode.valueOf(args[0].to_s))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_mode(#{args[0]})"
      end
    end
    #  Create a template engine using defaults
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @return [::VertxWebTemplThymeleaf::ThymeleafTemplateEngine] the engine
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTemplThymeleaf::ThymeleafTemplateEngine.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxWebTemplThymeleaf::ThymeleafTemplateEngine)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    def self.DEFAULT_TEMPLATE_MODE
      Java::IoVertxExtWebTemplThymeleaf::ThymeleafTemplateEngine.DEFAULT_TEMPLATE_MODE.name.intern
    end
  end
end
