require 'vertx/vertx'
require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.CSRFHandler
module VertxWeb
  #  This handler adds a CSRF token to requests which mutate state. In order change the state a (XSRF-TOKEN) cookie is set
  #  with a unique token, that is expected to be sent back in a (X-XSRF-TOKEN) header.
  # 
  #  The behavior is to check the request body header and cookie for validity.
  # 
  #  This Handler requires session support, thus should be added somewhere below Session and Body handlers.
  class CSRFHandler
    # @private
    # @param j_del [::VertxWeb::CSRFHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::CSRFHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CSRFHandler
    end
    def @@j_api_type.wrap(obj)
      CSRFHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::CSRFHandler.java_class
    end
    #  Set the timeout for tokens generated by the handler, by default it uses the default from the session handler.
    # @overload setTimeout(timeout)
    #   @param [Fixnum] timeout token timeout
    # @return [self]
    def set_timeout(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setTimeout, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_timeout(#{args[0]})"
      end
    end
    #  Set the cookie name. By default XSRF-TOKEN is used as it is the expected name by AngularJS however other frameworks
    #  might use other names.
    # @overload setCookieName(name)
    #   @param [String] name a new name for the cookie.
    # @return [self]
    def set_cookie_name(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setCookieName, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_cookie_name(#{args[0]})"
      end
    end
    #  Set the body returned by the handler when the XSRF token is missing or invalid.
    # @overload setResponseBody(responseBody)
    #   @param [String] responseBody the body of the response. If null, no response body will be returned.
    # @return [self]
    def set_response_body(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setResponseBody, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_response_body(#{args[0]})"
      end
    end
    #  Should the handler give warning messages if this handler is used in other than https protocols?
    # @overload setNagHttps(nag)
    #   @param [true,false] nag true to nag
    # @return [self]
    def set_nag_https(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setNagHttps, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_nag_https(#{args[0]})"
      end
    end
    #  Instantiate a new CSRFHandlerImpl with a secret
    #  <p>
    #  <pre>
    #  CSRFHandler.create("s3cr37")
    #  </pre>
    # @overload create(vertx,secret)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] secret server secret to sign the token.
    # @return [::VertxWeb::CSRFHandler]
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::CSRFHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxWeb::CSRFHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Set the header name. By default X-XSRF-TOKEN is used as it is the expected name by AngularJS however other
    #  frameworks might use other names.
    # @overload setHeaderName(name)
    #   @param [String] name a new name for the header.
    # @return [self]
    def set_header_name(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setHeaderName, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_header_name(#{args[0]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Set the cookie path. By default / is used.
    # @overload setCookiePath(path)
    #   @param [String] path a new path for the cookie.
    # @return [self]
    def set_cookie_path(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setCookiePath, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_cookie_path(#{args[0]})"
      end
    end
    def self.ERROR_MESSAGE
      Java::IoVertxExtWebHandler::CSRFHandler.ERROR_MESSAGE
    end
    def self.DEFAULT_COOKIE_NAME
      Java::IoVertxExtWebHandler::CSRFHandler.DEFAULT_COOKIE_NAME
    end
    def self.DEFAULT_COOKIE_PATH
      Java::IoVertxExtWebHandler::CSRFHandler.DEFAULT_COOKIE_PATH
    end
    def self.DEFAULT_HEADER_NAME
      Java::IoVertxExtWebHandler::CSRFHandler.DEFAULT_HEADER_NAME
    end
    def self.DEFAULT_RESPONSE_BODY
      Java::IoVertxExtWebHandler::CSRFHandler.DEFAULT_RESPONSE_BODY
    end
  end
end
