require 'vertx-web/session_store'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.sstore.LocalSessionStore
module VertxWeb
  #  A session store which is only available on a single node.
  #  <p>
  #  Can be used when sticky sessions are being used.
  class LocalSessionStore < ::VertxWeb::SessionStore
    # @private
    # @param j_del [::VertxWeb::LocalSessionStore] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::LocalSessionStore] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == LocalSessionStore
    end
    def @@j_api_type.wrap(obj)
      LocalSessionStore.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebSstore::LocalSessionStore.java_class
    end
    #  Create a session store
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    # @overload create(vertx,sessionMapName)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [String] sessionMapName name for map used to store sessions
    # @overload create(vertx,sessionMapName,reaperInterval)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [String] sessionMapName name for map used to store sessions
    #   @param [Fixnum] reaperInterval how often, in ms, to check for expired sessions
    # @return [::VertxWeb::LocalSessionStore] the session store
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::LocalSessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxWeb::LocalSessionStore)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::LocalSessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxWeb::LocalSessionStore)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::LocalSessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::long.java_class]).call(args[0].j_del,args[1],args[2]),::VertxWeb::LocalSessionStore)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Default length for a session id.
    #  More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
    def self.DEFAULT_SESSIONID_LENGTH
      Java::IoVertxExtWebSstore::LocalSessionStore.DEFAULT_SESSIONID_LENGTH
    end
    #  Default of how often, in ms, to check for expired sessions
    def self.DEFAULT_REAPER_INTERVAL
      Java::IoVertxExtWebSstore::LocalSessionStore.DEFAULT_REAPER_INTERVAL
    end
    #  Default name for map used to store sessions
    def self.DEFAULT_SESSION_MAP_NAME
      Java::IoVertxExtWebSstore::LocalSessionStore.DEFAULT_SESSION_MAP_NAME
    end
  end
end
