require 'vertx-web/sock_js_socket'
require 'vertx/vertx'
require 'vertx-web/router'
require 'vertx-web/routing_context'
require 'vertx-web/bridge_event'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.sockjs.SockJSHandler
module VertxWeb
  # 
  #  A handler that allows you to handle SockJS connections from clients.
  #  <p>
  #  We currently support version 0.3.3 of the SockJS protocol, which can be found in
  #  <a href="https://github.com/sockjs/sockjs-protocol/tree/v0.3.3">this tag:</a>
  class SockJSHandler
    # @private
    # @param j_del [::VertxWeb::SockJSHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::SockJSHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SockJSHandler
    end
    def @@j_api_type.wrap(obj)
      SockJSHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandlerSockjs::SockJSHandler.java_class
    end
    #  Set a SockJS socket handler. This handler will be called with a SockJS socket whenever a SockJS connection
    #  is made from a client
    # @overload socketHandler(handler)
    #   @yield the handler
    # @return [::VertxWeb::Router] a router to be mounted on an existing router
    def socket_handler
      if true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:socketHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::SockJSSocket)) unless !block_given? })),::VertxWeb::Router)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling socket_handler()"
      end
    end
    #  Create a SockJS handler
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] options options to configure the handler
    # @return [::VertxWeb::SockJSHandler] the handler
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandlerSockjs::SockJSHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxWeb::SockJSHandler)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandlerSockjs::SockJSHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtWebHandlerSockjs::SockJSHandlerOptions.java_class]).call(args[0].j_del,Java::IoVertxExtWebHandlerSockjs::SockJSHandlerOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxWeb::SockJSHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    # @overload handle(routingContext)
    #   @param [::VertxWeb::RoutingContext] routingContext the rounting context
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Like {::VertxWeb::SockJSHandler#bridge} but specifying a handler
    #  that will receive bridge events.
    # @overload bridge(bridgeOptions)
    #   @param [Hash{String => Object}] bridgeOptions options to configure the bridge with
    # @overload bridge(bridgeOptions,bridgeEventHandler)
    #   @param [Hash{String => Object}] bridgeOptions options to configure the bridge with
    #   @yield handler to receive bridge events
    # @return [::VertxWeb::Router] a router to be mounted on an existing router
    def bridge(*args)
      if args[0].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:bridge, [Java::IoVertxExtWebHandlerSockjs::BridgeOptions.java_class]).call(Java::IoVertxExtWebHandlerSockjs::BridgeOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::VertxWeb::Router)
      elsif args[0].class == Hash && true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:bridge, [Java::IoVertxExtWebHandlerSockjs::BridgeOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtWebHandlerSockjs::BridgeOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::BridgeEvent)) unless !block_given? })),::VertxWeb::Router)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling bridge(#{args[0]})"
      end
    end
  end
end
