require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.CompositeFuture
module Vertx
  #  The composite future wraps a list of {::Vertx::Futurefutures}, it is useful when several futures
  #  needs to be coordinated.
  #  The handlers set for the coordinated futures are overridden by the handler of the composite future.
  class CompositeFuture < ::Vertx::Future
    # @private
    # @param j_del [::Vertx::CompositeFuture] the java delegate
    def initialize(j_del)
      super(j_del, ::Vertx::CompositeFuture.j_api_type)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::CompositeFuture] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CompositeFuture
    end
    def @@j_api_type.wrap(obj)
      CompositeFuture.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCore::CompositeFuture.java_class
    end
    #  Like {::Vertx::CompositeFuture#all} but with 6 futures.
    # @overload all(futures)
    #   @param [Array<::Vertx::Future>] futures 
    # @overload all(f1,f2)
    #   @param [::Vertx::Future] f1 future
    #   @param [::Vertx::Future] f2 future
    # @overload all(f1,f2,f3)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    # @overload all(f1,f2,f3,f4)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    # @overload all(f1,f2,f3,f4,f5)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    # @overload all(f1,f2,f3,f4,f5,f6)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    #   @param [::Vertx::Future] f6 
    # @return [::Vertx::CompositeFuture]
    def self.all(*args)
      if args[0].class == Array && !block_given? && args[1] == nil && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element.j_del }),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && !block_given? && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && !block_given? && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && args[4].class.method_defined?(:j_del) && !block_given? && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del,args[4].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && args[4].class.method_defined?(:j_del) && args[5].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del,args[4].j_del,args[5].j_del),::Vertx::CompositeFuture)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling all(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]},#{args[5]})"
      end
    end
    #  Map the failure of a future to a specific <code>value</code>.<p>
    # 
    #  When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
    # 
    #  When this future succeeds, the result will be propagated to the returned future.
    # @overload otherwise(mapper)
    #   @yield the mapper function
    # @overload otherwise(value)
    #   @param [::Vertx::CompositeFuture] value the value that eventually completes the mapped future
    # @return [::Vertx::Future] the mapped future
    def otherwise(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del unless !block_given? })),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::IoVertxCore::CompositeFuture.java_class]).call(args[0].j_del),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling otherwise(#{args[0]})"
      end
    end
    # @overload setHandler(handler)
    #   @yield 
    # @return [self]
    def set_handler
      if true
        if (block_given?)
          @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::CompositeFuture) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::CompositeFuture) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_handler()"
      end
    end
    #  Handles a failure of this Future by returning the result of another Future.
    #  If the mapper fails, then the returned future will be failed with this failure.
    # @overload recover(mapper)
    #   @yield A function which takes the exception of a failure and returns a new future.
    # @return [::Vertx::Future] A recovered future
    def recover(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:recover, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del unless !block_given? })),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling recover(#{args[0]})"
      end
    end
    #  Returns a cause of a wrapped future
    # @overload cause(index)
    #   @param [Fixnum] index the wrapped future index
    # @return [Exception]
    def cause(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_throwable(@j_del.java_method(:cause, [Java::int.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cause(#{args[0]})"
      end
    end
    #  Returns true if a wrapped future is failed
    # @overload failed(index)
    #   @param [Fixnum] index the wrapped future index
    # @return [true,false]
    def failed?(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:failed, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling failed?(#{args[0]})"
      end
    end
    #  Returns the result of a wrapped future
    # @overload resultAt(index)
    #   @param [Fixnum] index the wrapped future index
    # @return [Object]
    def result_at(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:resultAt, [Java::int.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling result_at(#{args[0]})"
      end
    end
    # @overload getHandler()
    # @return [Proc] the handler for the result
    def get_handler
      if !block_given?
        return ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:getHandler, []).call()) { |val| val.j_del }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_handler()"
      end
    end
    #  Like {::Vertx::CompositeFuture#any} but with 6 futures.
    # @overload any(futures)
    #   @param [Array<::Vertx::Future>] futures 
    # @overload any(f1,f2)
    #   @param [::Vertx::Future] f1 future
    #   @param [::Vertx::Future] f2 future
    # @overload any(f1,f2,f3)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    # @overload any(f1,f2,f3,f4)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    # @overload any(f1,f2,f3,f4,f5)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    # @overload any(f1,f2,f3,f4,f5,f6)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    #   @param [::Vertx::Future] f6 
    # @return [::Vertx::CompositeFuture]
    def self.any(*args)
      if args[0].class == Array && !block_given? && args[1] == nil && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element.j_del }),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && !block_given? && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && !block_given? && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && args[4].class.method_defined?(:j_del) && !block_given? && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del,args[4].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && args[4].class.method_defined?(:j_del) && args[5].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del,args[4].j_del,args[5].j_del),::Vertx::CompositeFuture)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling any(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]},#{args[5]})"
      end
    end
    #  Map the failure of a future to <code>null</code>.<p>
    # 
    #  This is a convenience for <code>future.otherwise((T) null)</code>.<p>
    # 
    #  When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
    # 
    #  When this future succeeds, the result will be propagated to the returned future.
    # @overload otherwiseEmpty()
    # @return [::Vertx::Future] the mapped future
    def otherwise_empty
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwiseEmpty, []).call(),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling otherwise_empty()"
      end
    end
    #  The result of the operation. This will be null if the operation failed.
    # @overload result()
    # @return [::Vertx::CompositeFuture] the result or null if the operation failed.
    def result
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:result, []).call(),::Vertx::CompositeFuture)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling result()"
      end
    end
    # @overload size()
    # @return [Fixnum] the number of wrapped future
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    #  Compose this future with a <code>mapper</code> function.<p>
    # 
    #  When this future (the one on which <code>compose</code> is called) succeeds, the <code>mapper</code> will be called with
    #  the completed value and this mapper returns another future object. This returned future completion will complete
    #  the future returned by this method call.<p>
    # 
    #  If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
    #  will not be called.
    # @overload compose(mapper)
    #   @yield the mapper function
    # @return [::Vertx::Future] the composed future
    def compose(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:compose, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::CompositeFuture)).j_del unless !block_given? })),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling compose(#{args[0]})"
      end
    end
    #  Like {::Vertx::CompositeFuture#join} but with 6 futures.
    # @overload join(futures)
    #   @param [Array<::Vertx::Future>] futures 
    # @overload join(f1,f2)
    #   @param [::Vertx::Future] f1 future
    #   @param [::Vertx::Future] f2 future
    # @overload join(f1,f2,f3)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    # @overload join(f1,f2,f3,f4)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    # @overload join(f1,f2,f3,f4,f5)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    # @overload join(f1,f2,f3,f4,f5,f6)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    #   @param [::Vertx::Future] f6 
    # @return [::Vertx::CompositeFuture]
    def self.join(*args)
      if args[0].class == Array && !block_given? && args[1] == nil && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element.j_del }),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && !block_given? && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && !block_given? && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && args[4].class.method_defined?(:j_del) && !block_given? && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del,args[4].j_del),::Vertx::CompositeFuture)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class.method_defined?(:j_del) && args[3].class.method_defined?(:j_del) && args[4].class.method_defined?(:j_del) && args[5].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(args[0].j_del,args[1].j_del,args[2].j_del,args[3].j_del,args[4].j_del,args[5].j_del),::Vertx::CompositeFuture)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling join(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]},#{args[5]})"
      end
    end
    #  Apply a <code>mapper</code> function on this future.<p>
    # 
    #  When this future succeeds, the <code>mapper</code> will be called with the completed value and this mapper
    #  returns a value. This value will complete the future returned by this method call.<p>
    # 
    #  If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
    #  will not be called.
    # @overload map(mapper)
    #   @yield the mapper function
    # @return [::Vertx::Future] the mapped future
    def map(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:map, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.safe_create(event,::Vertx::CompositeFuture))) unless !block_given? })),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling map(#{args[0]})"
      end
    end
    #  Returns true if a wrapped future is completed
    # @overload isComplete(index)
    #   @param [Fixnum] index the wrapped future index
    # @return [true,false]
    def complete?(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:isComplete, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling complete?(#{args[0]})"
      end
    end
    #  Returns true if a wrapped future is succeeded
    # @overload succeeded(index)
    #   @param [Fixnum] index the wrapped future index
    # @return [true,false]
    def succeeded?(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:succeeded, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling succeeded?(#{args[0]})"
      end
    end
  end
end
