require 'vertx/pipe'
require 'vertx/buffer'
require 'vertx/datagram_packet'
require 'vertx/measured'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/socket_address'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.datagram.DatagramSocket
module Vertx
  #  A datagram socket can be used to send {::Vertx::DatagramPacket}'s to remote datagram servers
  #  and receive {::Vertx::DatagramPacket}s .
  #  <p>
  #  Usually you use a datagram socket to send UDP over the wire. UDP is connection-less which means you are not connected
  #  to the remote peer in a persistent way. Because of this you have to supply the address and port of the remote peer
  #  when sending data.
  #  <p>
  #  You can send data to ipv4 or ipv6 addresses, which also include multicast addresses.
  #  <p>
  #  Please consult the documentation for more information on datagram sockets.
  class DatagramSocket
    include ::Vertx::ReadStream
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::DatagramSocket] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::DatagramSocket] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == DatagramSocket
    end
    def @@j_api_type.wrap(obj)
      DatagramSocket.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreDatagram::DatagramSocket.java_class
    end
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    #  Whether the metrics are enabled for this measured object
    # @overload isMetricsEnabled()
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
      end
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::DatagramPacket)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Leaves a multicast group and stops listening for packets send to it on the given network interface.
    #  The  is notified once the operation completes.
    # @overload unlistenMulticastGroup(multicastAddress,handler)
    #   @param [String] multicastAddress the address of the multicast group to leave
    #   @yield then handler to notify once the operation completes
    # @overload unlistenMulticastGroup(multicastAddress,networkInterface,source,handler)
    #   @param [String] multicastAddress the address of the multicast group to join
    #   @param [String] networkInterface the network interface on which to listen for packets.
    #   @param [String] source the address of the source for which we will listen for multicast packets
    #   @yield the handler to notify once the operation completes
    # @return [self]
    def unlisten_multicast_group(*args)
      if args[0].class == String && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:unlistenMulticastGroup, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unlistenMulticastGroup, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:unlistenMulticastGroup, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unlistenMulticastGroup, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unlisten_multicast_group(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Joins a multicast group and listens for packets send to it on the given network interface.
    #  The  is notified once the operation completes.
    # @overload listenMulticastGroup(multicastAddress,handler)
    #   @param [String] multicastAddress the address of the multicast group to join
    #   @yield then handler to notify once the operation completes
    # @overload listenMulticastGroup(multicastAddress,networkInterface,source,handler)
    #   @param [String] multicastAddress the address of the multicast group to join
    #   @param [String] networkInterface the network interface on which to listen for packets.
    #   @param [String] source the address of the source for which we will listen for multicast packets
    #   @yield then handler to notify once the operation completes
    # @return [self]
    def listen_multicast_group(*args)
      if args[0].class == String && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:listenMulticastGroup, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listenMulticastGroup, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:listenMulticastGroup, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listenMulticastGroup, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listen_multicast_group(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Block the given address for the given multicast address on the given network interface and notifies
    #  the  once the operation completes.
    # @overload blockMulticastGroup(multicastAddress,sourceToBlock,handler)
    #   @param [String] multicastAddress the address for which you want to block the source address
    #   @param [String] sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
    #   @yield the handler to notify once the operation completes
    # @overload blockMulticastGroup(multicastAddress,networkInterface,sourceToBlock,handler)
    #   @param [String] multicastAddress the address for which you want to block the source address
    #   @param [String] networkInterface the network interface on which the blocking should occur.
    #   @param [String] sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
    #   @yield the handler to notify once the operation completes
    # @return [self]
    def block_multicast_group(*args)
      if args[0].class == String && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:blockMulticastGroup, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:blockMulticastGroup, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:blockMulticastGroup, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:blockMulticastGroup, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling block_multicast_group(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
    #  Start listening on the given port and host. The handler will be called when the socket is listening.
    # @overload listen(port,host,handler)
    #   @param [Fixnum] port the port to listen on
    #   @param [String] host the host to listen on
    #   @yield the handler will be called when listening
    # @return [self]
    def listen(*args)
      if args[0].class == Fixnum && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::DatagramSocket) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::DatagramSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::DatagramSocket.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listen(#{args[0]},#{args[1]})"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    #  Returns a <code>WriteStream<Buffer></code> able to send  to the
    #  {::Vertx::SocketAddress}.
    # @overload sender(port,host)
    #   @param [Fixnum] port the port of the remote peer
    #   @param [String] host the host address of the remote peer
    # @return [::Vertx::WriteStream] the write stream for sending packets
    def sender(*args)
      if args[0].class == Fixnum && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:sender, [Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::WriteStreamImpl,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling sender(#{args[0]},#{args[1]})"
      end
    end
    #  Return the {::Vertx::SocketAddress} to which
    #  this {::Vertx::DatagramSocket} is bound.
    # @overload localAddress()
    # @return [::Vertx::SocketAddress] the socket address
    def local_address
      if !block_given?
        if @cached_local_address != nil
          return @cached_local_address
        end
        return @cached_local_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:localAddress, []).call(),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling local_address()"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::DatagramPacket.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Closes the {::Vertx::DatagramSocket} implementation asynchronous
    #  and notifies the handler once done.
    # @overload close(handler)
    #   @yield the handler to notify once complete
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Write the given String to the {::Vertx::SocketAddress} using the given encoding.
    #  The  will be notified once the write completes.
    # @overload send(packet,port,host,handler)
    #   @param [::Vertx::Buffer] packet the {::Vertx::Buffer} to write
    #   @param [Fixnum] port the host port of the remote peer
    #   @param [String] host the host address of the remote peer
    #   @yield the {Proc} to notify once the write completes.
    # @overload send(str,port,host,handler)
    #   @param [String] str the String to write
    #   @param [Fixnum] port the host port of the remote peer
    #   @param [String] host the host address of the remote peer
    #   @yield the {Proc} to notify once the write completes.
    # @overload send(str,enc,port,host,handler)
    #   @param [String] str the String to write
    #   @param [String] enc the charset used for encoding
    #   @param [Fixnum] port the host port of the remote peer
    #   @param [String] host the host address of the remote peer
    #   @yield the {Proc} to notify once the write completes.
    # @return [self]
    def send(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Fixnum && args[2].class == String && true && args[3] == nil
        if (block_given?)
          @j_del.java_method(:send, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == Fixnum && args[2].class == String && true && args[3] == nil
        if (block_given?)
          @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && args[2].class == Fixnum && args[3].class == String && true
        if (block_given?)
          @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],args[3],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
  end
end
