require 'vertx/measured'
require 'vertx/future'
require 'vertx/net_socket'
require 'vertx/socket_address'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.net.NetClient
module Vertx
  #  A TCP client.
  #  <p>
  #  Multiple connections to different servers can be made using the same instance.
  #  <p>
  #  This client supports a configurable number of connection attempts and a configurable
  #  delay between attempts.
  class NetClient
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::NetClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::NetClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == NetClient
    end
    def @@j_api_type.wrap(obj)
      NetClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreNet::NetClient.java_class
    end
    #  Whether the metrics are enabled for this measured object
    # @overload isMetricsEnabled()
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
      end
    end
    #  Close the client.
    #  <p>
    #  Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
    #  complete until some time after the method has returned.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Open a connection to a server at the specific <code>port</code> and <code>host</code>.
    #  <p>
    #  <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
    #  {::Vertx::NetSocket} instance is supplied via the <code>connectHandler</code> instance
    # @overload connect(remoteAddress,connectHandler)
    #   @param [::Vertx::SocketAddress] remoteAddress the remote address
    #   @yield 
    # @overload connect(port,host,connectHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @yield 
    # @overload connect(remoteAddress,serverName,connectHandler)
    #   @param [::Vertx::SocketAddress] remoteAddress the remote address
    #   @param [String] serverName the SNI server name
    #   @yield 
    # @overload connect(port,host,serverName,connectHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] serverName the SNI server name
    #   @yield 
    # @return [self]
    def connect(*args)
      if args[0].class.method_defined?(:j_del) && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:connect, [Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::NetSocket.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::NetSocket.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:connect, [Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::NetSocket.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::NetSocket.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
  end
end
