require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.net.SelfSignedCertificate
module Vertx
  #  A self-signed certificate helper for testing and development purposes.
  #  <p>
  #  While it helps for testing and development, it should never ever be used in production settings.
  class SelfSignedCertificate
    # @private
    # @param j_del [::Vertx::SelfSignedCertificate] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::SelfSignedCertificate] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SelfSignedCertificate
    end
    def @@j_api_type.wrap(obj)
      SelfSignedCertificate.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreNet::SelfSignedCertificate.java_class
    end
    #  Filesystem path to the X.509 certificate file in PEM format .
    # @overload certificatePath()
    # @return [String] the absolute path to the certificate.
    def certificate_path
      if !block_given?
        return @j_del.java_method(:certificatePath, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling certificate_path()"
      end
    end
    #  Filesystem path to the RSA private key file in PEM format
    # @overload privateKeyPath()
    # @return [String] the absolute path to the private key.
    def private_key_path
      if !block_given?
        return @j_del.java_method(:privateKeyPath, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling private_key_path()"
      end
    end
    #  Create a new <code>SelfSignedCertificate</code> instance with a fully-qualified domain name,
    # @overload create()
    # @overload create(fqdn)
    #   @param [String] fqdn a fully qualified domain name.
    # @return [::Vertx::SelfSignedCertificate] a new instance.
    def self.create(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreNet::SelfSignedCertificate.java_method(:create, []).call(),::Vertx::SelfSignedCertificate)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreNet::SelfSignedCertificate.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::SelfSignedCertificate)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Provides the {Nil} X.509 certificate file in PEM format corresponding to the {::Vertx::SelfSignedCertificate#certificate_path}
    # @overload trustOptions()
    # @return [Hash{String => Object}] a {Hash{String => Object}} based on the generated certificate.
    def trust_options
      if !block_given?
        return @j_del.java_method(:trustOptions, []).call() != nil ? JSON.parse(@j_del.java_method(:trustOptions, []).call().toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling trust_options()"
      end
    end
    #  Provides the {Nil} RSA private key file in PEM format corresponding to the {::Vertx::SelfSignedCertificate#private_key_path}
    # @overload keyCertOptions()
    # @return [Hash{String => Object}] a {Hash{String => Object}} based on the generated certificate.
    def key_cert_options
      if !block_given?
        return @j_del.java_method(:keyCertOptions, []).call() != nil ? JSON.parse(@j_del.java_method(:keyCertOptions, []).call().toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling key_cert_options()"
      end
    end
    #  Delete the private key and certificate files.
    # @overload delete()
    # @return [void]
    def delete
      if !block_given?
        return @j_del.java_method(:delete, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete()"
      end
    end
  end
end
