require 'vertx/vertx'
require 'vertx-amqp-client/amqp_sender'
require 'vertx-amqp-client/amqp_connection'
require 'vertx-amqp-client/amqp_receiver'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpClient
module VertxAmqpClient
  #  AMQP Client entry point.
  #  Use this interface to create an instance of {::VertxAmqpClient::AmqpClient} and connect to a broker and server.
  class AmqpClient
    # @private
    # @param j_del [::VertxAmqpClient::AmqpClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpClient
    end
    def @@j_api_type.wrap(obj)
      AmqpClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpClient.java_class
    end
    #  Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
    #  explicitly. You can retrieve the connection using {::VertxAmqpClient::AmqpReceiver#connection}.
    # @overload createReceiver(address,completionHandler)
    #   @param [String] address The source address to attach the consumer to, must not be <code>null</code>
    #   @yield the handler called with the receiver. The receiver has been opened.
    # @overload createReceiver(address,receiverOptions,completionHandler)
    #   @param [String] address The source address to attach the consumer to.
    #   @param [Hash{String => Object}] receiverOptions The options for this receiver.
    #   @yield The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
    # @return [self]
    def create_receiver(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpReceiver.j_api_type)
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpReceiverOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxAmqp::AmqpReceiverOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpReceiverOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxAmqp::AmqpReceiverOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpReceiver.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_receiver(#{args[0]},#{args[1]})"
      end
    end
    #  Creates a sender used to send messages to the given address. The address must be set.
    # @overload createSender(address,completionHandler)
    #   @param [String] address The target address to attach to, must not be <code>null</code>
    #   @yield The handler called with the sender, once opened
    # @overload createSender(address,options,completionHandler)
    #   @param [String] address The target address to attach to, must not be <code>null</code>
    #   @param [Hash{String => Object}] options The options for this sender.
    #   @yield The handler called with the sender, once opened
    # @return [self]
    def create_sender(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpSender.j_api_type)
        end
      elsif args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpSenderOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxAmqp::AmqpSenderOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpSenderOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],Java::IoVertxAmqp::AmqpSenderOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpSender.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_sender(#{args[0]},#{args[1]})"
      end
    end
    #  Creates a new instance of {::VertxAmqpClient::AmqpClient} with the given Vert.x instance and the given options.
    # @overload create(options)
    #   @param [Hash{String => Object}] options the AMQP client options, may be <code>null</code> falling back to the default configuration
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vert.x instance, must not be <code>null</code>
    #   @param [Hash{String => Object}] options the AMQP options, may be @{code null} falling back to the default configuration
    # @return [::VertxAmqpClient::AmqpClient] the AMQP client instance
    def self.create(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxAmqp::AmqpClient.java_method(:create, [Java::IoVertxAmqp::AmqpClientOptions.java_class]).call(Java::IoVertxAmqp::AmqpClientOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::VertxAmqpClient::AmqpClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxAmqp::AmqpClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxAmqp::AmqpClientOptions.java_class]).call(args[0].j_del,Java::IoVertxAmqp::AmqpClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxAmqpClient::AmqpClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Closes the client.
    #  The client must always be closed once not needed anymore.
    # @overload close(closeHandler)
    #   @yield the close handler notified when the operation completes. It can be <code>null</code>.
    # @return [void]
    def close
      if true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Connects to the AMQP broker or router. The location is specified in the {Hash{String => Object}} as well as the
    #  potential credential required.
    # @overload connect(connectionHandler)
    #   @yield handler that will process the result, giving either the connection or failure cause. Must not be <code>null</code>.
    # @return [self]
    def connect
      if true
        if (block_given?)
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpConnection) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAmqpClient::AmqpConnection.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect()"
      end
    end
  end
end
