require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.ChainAuth
module VertxAuthCommon
  #  Chain several auth providers as if they were one. This is useful for cases where one want to authenticate across
  #  several providers, for example, database and fallback to passwd file.
  class ChainAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthCommon::ChainAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::ChainAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ChainAuth
    end
    def @@j_api_type.wrap(obj)
      ChainAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuth::ChainAuth.java_class
    end
    #  Clears the chain.
    # @overload clear()
    # @return [void]
    def clear
      if !block_given?
        return @j_del.java_method(:clear, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clear()"
      end
    end
    #  Create a Chainable Auth Provider auth provider
    # @overload create()
    # @return [::VertxAuthCommon::ChainAuth] the auth provider
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuth::ChainAuth.java_method(:create, []).call(),::VertxAuthCommon::ChainAuth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
    #  Removes a provider from the chain.
    # @overload remove(other)
    #   @param [::VertxAuthCommon::AuthProvider] other provider to remove
    # @return [true,false] true if provider was removed, false if non existent in the chain.
    def remove?(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:remove, [Java::IoVertxExtAuth::AuthProvider.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove?(#{args[0]})"
      end
    end
    #  Appends a auth provider to the chain.
    # @overload append(other)
    #   @param [::VertxAuthCommon::AuthProvider] other auth provider
    # @return [self]
    def append(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:append, [Java::IoVertxExtAuth::AuthProvider.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append(#{args[0]})"
      end
    end
  end
end
