require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.HashingAlgorithm
module VertxAuthCommon
  #  Hashing Algorithm. A common interface to interact with any system provided algorithms.
  class HashingAlgorithm
    # @private
    # @param j_del [::VertxAuthCommon::HashingAlgorithm] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::HashingAlgorithm] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HashingAlgorithm
    end
    def @@j_api_type.wrap(obj)
      HashingAlgorithm.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuth::HashingAlgorithm.java_class
    end
    #  Should the encoded string use the default separator to split fields.
    # @overload needsSeparator()
    # @return [true,false] true by default.
    def needs_separator?
      if !block_given?
        return @j_del.java_method(:needsSeparator, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling needs_separator?()"
      end
    end
    #  return the symbolic name for the algorithm
    # @overload id()
    # @return [String] short id e.g.: sha512.
    def id
      if !block_given?
        return @j_del.java_method(:id, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling id()"
      end
    end
    #  return the list of param names required for this algorithm.
    # @overload params()
    # @return [Set<String>] set of param names.
    def params
      if !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:params, []).call()).map! { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling params()"
      end
    end
  end
end
