require 'vertx/vertx'
require 'vertx/read_stream'
require 'vertx-mongo/mongo_grid_fs_client'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.mongo.MongoClient
module VertxMongo
  #  A Vert.x service used to interact with MongoDB server instances.
  #  <p>
  #  Some of the operations might change <i>_id</i> field of passed  document.
  class MongoClient
    # @private
    # @param j_del [::VertxMongo::MongoClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMongo::MongoClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MongoClient
    end
    def @@j_api_type.wrap(obj)
      MongoClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtMongo::MongoClient.java_class
    end
    #  Find matching documents in the specified collection.
    #  This method use batchCursor for returning each found document.
    # @overload findBatch(collection,query)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    # @return [::Vertx::ReadStream] a  emitting found documents
    def find_batch(*args)
      if args[0].class == String && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:findBatch, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1])),::Vertx::ReadStreamImpl, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_batch(#{args[0]},#{args[1]})"
      end
    end
    #  Remove matching documents from a collection with the specified write option
    # @overload removeWithOptions(collection,query,writeOption,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    #   @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] writeOption the write option to use
    #   @yield will be called when complete
    # @return [self]
    def remove_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:removeWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:removeWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Remove a single matching document from a collection with the specified write option and return the handler with MongoClientDeleteResult result
    # @overload removeDocumentWithOptions(collection,query,writeOption,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match document
    #   @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] writeOption the write option to use
    #   @yield will be called when complete
    # @return [self]
    def remove_document_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:removeDocumentWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:removeDocumentWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientDeleteResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_document_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Replace matching documents in the specified collection
    #  <p>
    #  This operation might change <i>_id</i> field of <i>replace</i> parameter
    # @overload replace(collection,query,replace,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match the documents
    #   @param [Hash{String => Object}] replace all matching documents will be replaced with this
    #   @yield will be called when complete
    # @return [self]
    def replace(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:replace, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:replace, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling replace(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Get a list of all collections in the database.
    # @overload getCollections(resultHandler)
    #   @yield will be called with a list of collections.
    # @return [self]
    def get_collections
      if true
        if (block_given?)
          @j_del.java_method(:getCollections, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getCollections, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_collections()"
      end
    end
    #  Creates an index.
    # @overload createIndexWithOptions(collection,key,options,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
    #   @param [Hash{String => Object}] options the options for the index
    #   @yield will be called when complete
    # @return [self]
    def create_index_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createIndexWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::IndexOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::IndexOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createIndexWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::IndexOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::IndexOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_index_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Remove matching documents from a collection and return the handler with MongoClientDeleteResult result
    # @overload removeDocuments(collection,query,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    #   @yield will be called when complete
    # @return [self]
    def remove_documents(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:removeDocuments, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:removeDocuments, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientDeleteResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_documents(#{args[0]},#{args[1]})"
      end
    end
    #  Find a single matching document in the specified collection and update it.
    #  <p>
    #  This operation might change <i>_id</i> field of <i>query</i> parameter
    # @overload findOneAndUpdate(collection,query,update,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query the query used to match the document
    #   @param [Hash{String => Object}] update used to describe how the documents will be updated
    #   @yield will be provided with the document, if any
    # @return [self]
    def find_one_and_update(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findOneAndUpdate, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findOneAndUpdate, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_one_and_update(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Drops the index given its name.
    # @overload dropIndex(collection,indexName,resultHandler)
    #   @param [String] collection the collection
    #   @param [String] indexName the name of the index to remove
    #   @yield will be called when complete
    # @return [self]
    def drop_index(*args)
      if args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:dropIndex, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:dropIndex, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling drop_index(#{args[0]},#{args[1]})"
      end
    end
    #  Gets the distinct values of the specified field name filtered by specified query.
    #  This method use batchCursor for returning each found value.
    #  Each value is a json fragment with fieldName key (eg: {"num": 1}).
    # @overload distinctBatchWithQuery(collection,fieldName,resultClassname,query)
    #   @param [String] collection the collection
    #   @param [String] fieldName the field name
    #   @param [String] resultClassname 
    #   @param [Hash{String => Object}] query the query
    # @overload distinctBatchWithQuery(collection,fieldName,resultClassname,query,batchSize)
    #   @param [String] collection the collection
    #   @param [String] fieldName the field name
    #   @param [String] resultClassname 
    #   @param [Hash{String => Object}] query the query
    #   @param [Fixnum] batchSize the number of documents to load in a batch
    # @return [::Vertx::ReadStream] a  emitting json fragments
    def distinct_batch_with_query(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == Hash && !block_given? && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:distinctBatchWithQuery, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],args[1],args[2],::Vertx::Util::Utils.to_json_object(args[3])),::Vertx::ReadStreamImpl, nil)
      elsif args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == Hash && args[4].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:distinctBatchWithQuery, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::int.java_class]).call(args[0],args[1],args[2],::Vertx::Util::Utils.to_json_object(args[3]),args[4]),::Vertx::ReadStreamImpl, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling distinct_batch_with_query(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Save a document in the specified collection with the specified write option
    #  <p>
    #  This operation might change <i>_id</i> field of <i>document</i> parameter
    # @overload saveWithOptions(collection,document,writeOption,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] document the document
    #   @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] writeOption the write option to use
    #   @yield result handler will be provided with the id if document didn't already have one
    # @return [self]
    def save_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:saveWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:saveWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling save_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Remove a single matching document from a collection with the specified write option
    # @overload removeOneWithOptions(collection,query,writeOption,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match document
    #   @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] writeOption the write option to use
    #   @yield will be called when complete
    # @return [self]
    def remove_one_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:removeOneWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:removeOneWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_one_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Find matching documents in the specified collection
    # @overload find(collection,query,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    #   @yield will be provided with list of documents
    # @return [self]
    def find(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:find, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:find, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find(#{args[0]},#{args[1]})"
      end
    end
    #  Gets the distinct values of the specified field name filtered by specified query.
    #  Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
    # @overload distinctWithQuery(collection,fieldName,resultClassname,query,resultHandler)
    #   @param [String] collection the collection
    #   @param [String] fieldName the field name
    #   @param [String] resultClassname 
    #   @param [Hash{String => Object}] query the query
    #   @yield will be provided with array of values.
    # @return [self]
    def distinct_with_query(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == Hash && true
        if (block_given?)
          @j_del.java_method(:distinctWithQuery, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],::Vertx::Util::Utils.to_json_object(args[3]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:distinctWithQuery, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],::Vertx::Util::Utils.to_json_object(args[3]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling distinct_with_query(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Replace matching documents in the specified collection, specifying options
    #  <p>
    #  This operation might change <i>_id</i> field of <i>replace</i> parameter
    # @overload replaceWithOptions(collection,query,replace,options,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match the documents
    #   @param [Hash{String => Object}] replace all matching documents will be replaced with this
    #   @param [Hash{String => Object}] options options to configure the replace
    #   @yield will be called when complete
    # @return [self]
    def replace_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && args[3].class == Hash && true
        if (block_given?)
          @j_del.java_method(:replaceWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:replaceWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling replace_with_options(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Run aggregate MongoDB command.
    # @overload aggregateWithOptions(collection,pipeline,options)
    #   @param [String] collection the collection
    #   @param [Array<String,Object>] pipeline aggregation pipeline to be executed
    #   @param [Hash{String => Object}] options options to configure the aggregation command
    # @return [::Vertx::ReadStream]
    def aggregate_with_options(*args)
      if args[0].class == String && args[1].class == Array && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:aggregateWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxExtMongo::AggregateOptions.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),Java::IoVertxExtMongo::AggregateOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::Vertx::ReadStreamImpl, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling aggregate_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Creates a {::VertxMongo::MongoGridFsClient} used to interact with Mongo GridFS.
    # @overload createDefaultGridFsBucketService(resultHandler)
    #   @yield the {::VertxMongo::MongoGridFsClient} to interact with the bucket named bucketName
    # @return [self]
    def create_default_grid_fs_bucket_service
      if true
        if (block_given?)
          @j_del.java_method(:createDefaultGridFsBucketService, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoGridFsClient) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createDefaultGridFsBucketService, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoGridFsClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMongo::MongoGridFsClient.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_default_grid_fs_bucket_service()"
      end
    end
    #  Count matching documents in a collection.
    # @overload count(collection,query,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    #   @yield will be provided with the number of matching documents
    # @return [self]
    def count(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:count, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:count, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling count(#{args[0]},#{args[1]})"
      end
    end
    #  Insert a document in the specified collection with the specified write option
    #  <p>
    #  This operation might change <i>_id</i> field of <i>document</i> parameter
    # @overload insertWithOptions(collection,document,writeOption,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] document the document
    #   @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] writeOption the write option to use
    #   @yield result handler will be provided with the id if document didn't already have one
    # @return [self]
    def insert_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:insertWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:insertWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling insert_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Find a single matching document in the specified collection and replace it.
    #  <p>
    #  This operation might change <i>_id</i> field of <i>query</i> parameter
    # @overload findOneAndReplaceWithOptions(collection,query,replace,findOptions,updateOptions,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query the query used to match the document
    #   @param [Hash{String => Object}] replace the replacement document
    #   @param [Hash{String => Object}] findOptions options to configure the find
    #   @param [Hash{String => Object}] updateOptions options to configure the update
    #   @yield will be provided with the document, if any
    # @return [self]
    def find_one_and_replace_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && args[3].class == Hash && args[4].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findOneAndReplaceWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[4])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findOneAndReplaceWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[4])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_one_and_replace_with_options(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Remove a single matching document from a collection
    # @overload removeOne(collection,query,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match document
    #   @yield will be called when complete
    # @return [self]
    def remove_one(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:removeOne, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:removeOne, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_one(#{args[0]},#{args[1]})"
      end
    end
    #  Gets the distinct values of the specified field name.
    #  This method use batchCursor for returning each found value.
    #  Each value is a json fragment with fieldName key (eg: {"num": 1}).
    # @overload distinctBatch(collection,fieldName,resultClassname)
    #   @param [String] collection the collection
    #   @param [String] fieldName the field name
    #   @param [String] resultClassname 
    # @return [::Vertx::ReadStream] a  emitting json fragments
    def distinct_batch(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:distinctBatch, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2]),::Vertx::ReadStreamImpl, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling distinct_batch(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Creates a {::VertxMongo::MongoGridFsClient} used to interact with Mongo GridFS.
    # @overload createGridFsBucketService(bucketName,resultHandler)
    #   @param [String] bucketName the name of the GridFS bucket
    #   @yield the {::VertxMongo::MongoGridFsClient} to interact with the bucket named bucketName
    # @return [self]
    def create_grid_fs_bucket_service(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:createGridFsBucketService, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoGridFsClient) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createGridFsBucketService, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoGridFsClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMongo::MongoGridFsClient.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_grid_fs_bucket_service(#{args[0]})"
      end
    end
    #  Find matching documents in the specified collection, specifying options.
    #  This method use batchCursor for returning each found document.
    # @overload findBatchWithOptions(collection,query,options)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    #   @param [Hash{String => Object}] options options to configure the find
    # @return [::Vertx::ReadStream] a  emitting found documents
    def find_batch_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:findBatchWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::Vertx::ReadStreamImpl, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_batch_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Find a single matching document in the specified collection and delete it.
    #  <p>
    #  This operation might change <i>_id</i> field of <i>query</i> parameter
    # @overload findOneAndDeleteWithOptions(collection,query,findOptions,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query the query used to match the document
    #   @param [Hash{String => Object}] findOptions options to configure the find
    #   @yield will be provided with the deleted document, if any
    # @return [self]
    def find_one_and_delete_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findOneAndDeleteWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findOneAndDeleteWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_one_and_delete_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create a new collection
    # @overload createCollection(collectionName,resultHandler)
    #   @param [String] collectionName the name of the collection
    #   @yield will be called when complete
    # @return [self]
    def create_collection(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:createCollection, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createCollection, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_collection(#{args[0]})"
      end
    end
    #  Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
    # @overload bulkWrite(collection,operations,resultHandler)
    #   @param [String] collection the collection
    #   @param [Array<Hash{String => Object}>] operations the operations to execute
    #   @yield will be called with a {Hash{String => Object}} when complete
    # @return [self]
    def bulk_write(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:bulkWrite, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| Java::IoVertxExtMongo::BulkOperation.new(::Vertx::Util::Utils.to_json_object(element)) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:bulkWrite, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| Java::IoVertxExtMongo::BulkOperation.new(::Vertx::Util::Utils.to_json_object(element)) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientBulkWriteResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling bulk_write(#{args[0]},#{args[1]})"
      end
    end
    #  Find a single matching document in the specified collection
    #  <p>
    #  This operation might change <i>_id</i> field of <i>query</i> parameter
    # @overload findOne(collection,query,fields,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query the query used to match the document
    #   @param [Hash{String => Object}] fields the fields
    #   @yield will be provided with the document, if any
    # @return [self]
    def find_one(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findOne, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findOne, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_one(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Save a document in the specified collection
    #  <p>
    #  This operation might change <i>_id</i> field of <i>document</i> parameter
    # @overload save(collection,document,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] document the document
    #   @yield result handler will be provided with the id if document didn't already have one
    # @return [self]
    def save(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:save, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:save, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling save(#{args[0]},#{args[1]})"
      end
    end
    #  Gets the distinct values of the specified field name.
    #  Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
    # @overload distinct(collection,fieldName,resultClassname,resultHandler)
    #   @param [String] collection the collection
    #   @param [String] fieldName the field name
    #   @param [String] resultClassname 
    #   @yield will be provided with array of values.
    # @return [self]
    def distinct(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:distinct, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:distinct, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling distinct(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Find a single matching document in the specified collection and replace it.
    #  <p>
    #  This operation might change <i>_id</i> field of <i>query</i> parameter
    # @overload findOneAndReplace(collection,query,replace,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query the query used to match the document
    #   @param [Hash{String => Object}] replace the replacement document
    #   @yield will be provided with the document, if any
    # @return [self]
    def find_one_and_replace(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findOneAndReplace, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findOneAndReplace, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_one_and_replace(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Update matching documents in the specified collection
    # @overload update(collection,query,update,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match the documents
    #   @param [Hash{String => Object}] update used to describe how the documents will be updated
    #   @yield will be called when complete
    # @return [self]
    def update(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:update, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:update, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Insert a document in the specified collection
    #  <p>
    #  This operation might change <i>_id</i> field of <i>document</i> parameter
    # @overload insert(collection,document,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] document the document
    #   @yield result handler will be provided with the id if document didn't already have one
    # @return [self]
    def insert(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:insert, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:insert, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling insert(#{args[0]},#{args[1]})"
      end
    end
    #  Update matching documents in the specified collection, specifying options and return the handler with MongoClientUpdateResult result
    # @overload updateCollectionWithOptions(collection,query,update,options,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match the documents
    #   @param [Hash{String => Object}] update used to describe how the documents will be updated
    #   @param [Hash{String => Object}] options options to configure the update
    #   @yield will be called when complete
    # @return [self]
    def update_collection_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && args[3].class == Hash && true
        if (block_given?)
          @j_del.java_method(:updateCollectionWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateCollectionWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientUpdateResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_collection_with_options(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Remove matching documents from a collection
    # @overload remove(collection,query,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    #   @yield will be called when complete
    # @return [self]
    def remove(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:remove, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:remove, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove(#{args[0]},#{args[1]})"
      end
    end
    #  Run aggregate MongoDB command with default {Hash{String => Object}}.
    # @overload aggregate(collection,pipeline)
    #   @param [String] collection the collection
    #   @param [Array<String,Object>] pipeline aggregation pipeline to be executed
    # @return [::Vertx::ReadStream]
    def aggregate(*args)
      if args[0].class == String && args[1].class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:aggregate, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1])),::Vertx::ReadStreamImpl, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling aggregate(#{args[0]},#{args[1]})"
      end
    end
    #  Update matching documents in the specified collection, specifying options
    # @overload updateWithOptions(collection,query,update,options,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match the documents
    #   @param [Hash{String => Object}] update used to describe how the documents will be updated
    #   @param [Hash{String => Object}] options options to configure the update
    #   @yield will be called when complete
    # @return [self]
    def update_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && args[3].class == Hash && true
        if (block_given?)
          @j_del.java_method(:updateWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_with_options(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Find a single matching document in the specified collection and update it.
    #  <p>
    #  This operation might change <i>_id</i> field of <i>query</i> parameter
    # @overload findOneAndUpdateWithOptions(collection,query,update,findOptions,updateOptions,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query the query used to match the document
    #   @param [Hash{String => Object}] update used to describe how the documents will be updated
    #   @param [Hash{String => Object}] findOptions options to configure the find
    #   @param [Hash{String => Object}] updateOptions options to configure the update
    #   @yield will be provided with the document, if any
    # @return [self]
    def find_one_and_update_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && args[3].class == Hash && args[4].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findOneAndUpdateWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[4])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findOneAndUpdateWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[4])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_one_and_update_with_options(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Find matching documents in the specified collection, specifying options
    # @overload findWithOptions(collection,query,options,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    #   @param [Hash{String => Object}] options options to configure the find
    #   @yield will be provided with list of documents
    # @return [self]
    def find_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create a Mongo client which shares its data source with any other Mongo clients created with the same
    #  data source name
    # @overload createShared(vertx,config)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] config the configuration
    # @overload createShared(vertx,config,dataSourceName)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] config the configuration
    #   @param [String] dataSourceName the data source name
    # @return [::VertxMongo::MongoClient] the client
    def self.create_shared(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMongo::MongoClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1])),::VertxMongo::MongoClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMongo::MongoClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),args[2]),::VertxMongo::MongoClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_shared(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Run an arbitrary MongoDB command.
    # @overload runCommand(commandName,command,resultHandler)
    #   @param [String] commandName the name of the command
    #   @param [Hash{String => Object}] command the command
    #   @yield will be called with the result.
    # @return [self]
    def run_command(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:runCommand, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:runCommand, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling run_command(#{args[0]},#{args[1]})"
      end
    end
    #  Replace matching documents in the specified collection and return the handler with MongoClientUpdateResult result
    # @overload replaceDocuments(collection,query,replace,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match the documents
    #   @param [Hash{String => Object}] replace all matching documents will be replaced with this
    #   @yield will be called when complete
    # @return [self]
    def replace_documents(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:replaceDocuments, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:replaceDocuments, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientUpdateResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling replace_documents(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Create a Mongo client which maintains its own data source.
    # @overload createNonShared(vertx,config)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] config the configuration
    # @return [::VertxMongo::MongoClient] the client
    def self.create_non_shared(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMongo::MongoClient.java_method(:createNonShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1])),::VertxMongo::MongoClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_non_shared(#{args[0]},#{args[1]})"
      end
    end
    #  Close the client and release its resources
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  creates an indexes
    # @overload createIndexes(collection,indexes,resultHandler)
    #   @param [String] collection the collection
    #   @param [Array<Hash{String => Object}>] indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
    #   @yield will be called when complete
    # @return [self]
    def create_indexes(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:createIndexes, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| Java::IoVertxExtMongo::IndexModel.new(::Vertx::Util::Utils.to_json_object(element)) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createIndexes, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| Java::IoVertxExtMongo::IndexModel.new(::Vertx::Util::Utils.to_json_object(element)) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_indexes(#{args[0]},#{args[1]})"
      end
    end
    #  Remove matching documents from a collection with the specified write option and return the handler with MongoClientDeleteResult result
    # @overload removeDocumentsWithOptions(collection,query,writeOption,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match documents
    #   @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] writeOption the write option to use
    #   @yield will be called when complete
    # @return [self]
    def remove_documents_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:removeDocumentsWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:removeDocumentsWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),Java::IoVertxExtMongo::WriteOption.valueOf(args[2].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientDeleteResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_documents_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Replace matching documents in the specified collection, specifying options and return the handler with MongoClientUpdateResult result
    # @overload replaceDocumentsWithOptions(collection,query,replace,options,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match the documents
    #   @param [Hash{String => Object}] replace all matching documents will be replaced with this
    #   @param [Hash{String => Object}] options options to configure the replace
    #   @yield will be called when complete
    # @return [self]
    def replace_documents_with_options(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && args[3].class == Hash && true
        if (block_given?)
          @j_del.java_method(:replaceDocumentsWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:replaceDocumentsWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(args[3])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientUpdateResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling replace_documents_with_options(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Remove a single matching document from a collection and return the handler with MongoClientDeleteResult result
    # @overload removeDocument(collection,query,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match document
    #   @yield will be called when complete
    # @return [self]
    def remove_document(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:removeDocument, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:removeDocument, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientDeleteResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_document(#{args[0]},#{args[1]})"
      end
    end
    #  Creates an index.
    # @overload createIndex(collection,key,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
    #   @yield will be called when complete
    # @return [self]
    def create_index(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:createIndex, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:createIndex, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_index(#{args[0]},#{args[1]})"
      end
    end
    #  Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
    #  documents with one request.
    # @overload bulkWriteWithOptions(collection,operations,bulkWriteOptions,resultHandler)
    #   @param [String] collection the collection
    #   @param [Array<Hash{String => Object}>] operations the operations to execute
    #   @param [Hash{String => Object}] bulkWriteOptions the write options
    #   @yield will be called with a {Hash{String => Object}} when complete
    # @return [self]
    def bulk_write_with_options(*args)
      if args[0].class == String && args[1].class == Array && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:bulkWriteWithOptions, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxExtMongo::BulkWriteOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| Java::IoVertxExtMongo::BulkOperation.new(::Vertx::Util::Utils.to_json_object(element)) },Java::IoVertxExtMongo::BulkWriteOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:bulkWriteWithOptions, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxExtMongo::BulkWriteOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| Java::IoVertxExtMongo::BulkOperation.new(::Vertx::Util::Utils.to_json_object(element)) },Java::IoVertxExtMongo::BulkWriteOptions.new(::Vertx::Util::Utils.to_json_object(args[2])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientBulkWriteResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling bulk_write_with_options(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Get all the indexes in this collection.
    # @overload listIndexes(collection,resultHandler)
    #   @param [String] collection the collection
    #   @yield will be called when complete
    # @return [self]
    def list_indexes(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:listIndexes, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listIndexes, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling list_indexes(#{args[0]})"
      end
    end
    #  Find a single matching document in the specified collection and delete it.
    #  <p>
    #  This operation might change <i>_id</i> field of <i>query</i> parameter
    # @overload findOneAndDelete(collection,query,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query the query used to match the document
    #   @yield will be provided with the deleted document, if any
    # @return [self]
    def find_one_and_delete(*args)
      if args[0].class == String && args[1].class == Hash && true
        if (block_given?)
          @j_del.java_method(:findOneAndDelete, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:findOneAndDelete, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling find_one_and_delete(#{args[0]},#{args[1]})"
      end
    end
    #  Drop a collection
    # @overload dropCollection(collection,resultHandler)
    #   @param [String] collection the collection
    #   @yield will be called when complete
    # @return [self]
    def drop_collection(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:dropCollection, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:dropCollection, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling drop_collection(#{args[0]})"
      end
    end
    #  Update matching documents in the specified collection and return the handler with MongoClientUpdateResult result
    # @overload updateCollection(collection,query,update,resultHandler)
    #   @param [String] collection the collection
    #   @param [Hash{String => Object}] query query used to match the documents
    #   @param [Hash{String => Object}] update used to describe how the documents will be updated
    #   @yield will be called when complete
    # @return [self]
    def update_collection(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          @j_del.java_method(:updateCollection, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateCollection, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtMongo::MongoClientUpdateResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_collection(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  The name of the default pool
    def self.DEFAULT_POOL_NAME
      Java::IoVertxExtMongo::MongoClient.DEFAULT_POOL_NAME
    end
    #  The name of the default database
    def self.DEFAULT_DB_NAME
      Java::IoVertxExtMongo::MongoClient.DEFAULT_DB_NAME
    end
  end
end
