require 'vertx-mqtt/mqtt_unsubscribe_message'
require 'vertx/buffer'
require 'vertx-mqtt/mqtt_subscribe_message'
require 'vertx-mqtt/mqtt_publish_message'
require 'vertx/future'
require 'vertx/socket_address'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.mqtt.MqttEndpoint
module VertxMqtt
  #  Represents an MQTT endpoint for point-to-point communication with the remote MQTT client
  class MqttEndpoint
    # @private
    # @param j_del [::VertxMqtt::MqttEndpoint] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMqtt::MqttEndpoint] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MqttEndpoint
    end
    def @@j_api_type.wrap(obj)
      MqttEndpoint.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMqtt::MqttEndpoint.java_class
    end
    #  Sends the PUBREL message to the remote MQTT client
    # @overload publishRelease(publishMessageId)
    #   @param [Fixnum] publishMessageId identifier of the PUBLISH message to acknowledge
    # @return [self]
    def publish_release(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:publishRelease, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_release(#{args[0]})"
      end
    end
    #  Sends the PUBCOMP message to the remote MQTT client
    # @overload publishComplete(publishMessageId)
    #   @param [Fixnum] publishMessageId identifier of the PUBLISH message to acknowledge
    # @return [self]
    def publish_complete(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:publishComplete, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_complete(#{args[0]})"
      end
    end
    # @overload auth()
    # @return [Hash{String => Object}] the Authentication information as provided by the remote MQTT client
    def auth
      if !block_given?
        if @cached_auth != nil
          return @cached_auth
        end
        return @cached_auth = @j_del.java_method(:auth, []).call() != nil ? JSON.parse(@j_del.java_method(:auth, []).call().toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling auth()"
      end
    end
    #  Set the pubcomp handler on the MQTT endpoint. This handler is called when a PUBCOMP
    #  message is received by the remote MQTT client
    # @overload publishCompletionHandler(handler)
    #   @yield the handler
    # @return [self]
    def publish_completion_handler
      if true
        @j_del.java_method(:publishCompletionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_completion_handler()"
      end
    end
    # @overload isConnected()
    # @return [true,false] if the connection between remote client and local endpoint is established/open
    def connected?
      if !block_given?
        return @j_del.java_method(:isConnected, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connected?()"
      end
    end
    # @overload isPublishAutoAck()
    # @return [true,false] auto acknowledge status for publishing (in/out)
    def publish_auto_ack?
      if !block_given?
        return @j_del.java_method(:isPublishAutoAck, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_auto_ack?()"
      end
    end
    #  Set the pingreq handler on the MQTT endpoint. This handler is called when a PINGREQ
    #  message is received by the remote MQTT client. In any case the endpoint sends the
    #  PINGRESP internally after executing this handler.
    # @overload pingHandler(handler)
    #   @yield the handler
    # @return [self]
    def ping_handler
      if true
        @j_del.java_method(:pingHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ping_handler()"
      end
    end
    #  Set the pubrec handler on the MQTT endpoint. This handler is called when a PUBREC
    #  message is received by the remote MQTT client
    # @overload publishReceivedHandler(handler)
    #   @yield the handler
    # @return [self]
    def publish_received_handler
      if true
        @j_del.java_method(:publishReceivedHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_received_handler()"
      end
    end
    #  Enable/disable subscription/unsubscription requests auto acknowledge
    # @overload subscriptionAutoAck(isSubscriptionAutoAck)
    #   @param [true,false] isSubscriptionAutoAck auto acknowledge status
    # @return [void]
    def subscription_auto_ack(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return @j_del.java_method(:subscriptionAutoAck, [Java::boolean.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscription_auto_ack(#{args[0]})"
      end
    end
    #  Set a unsubscribe handler on the MQTT endpoint. This handler is called when a UNSUBSCRIBE
    #  message is received by the remote MQTT client
    # @overload unsubscribeHandler(handler)
    #   @yield the handler
    # @return [self]
    def unsubscribe_handler
      if true
        @j_del.java_method(:unsubscribeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxMqtt::MqttUnsubscribeMessage)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unsubscribe_handler()"
      end
    end
    #  Sends the PINGRESP message to the remote MQTT client
    # @overload pong()
    # @return [self]
    def pong
      if !block_given?
        @j_del.java_method(:pong, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pong()"
      end
    end
    #  Set the puback handler on the MQTT endpoint. This handler is called when a PUBACK
    #  message is received by the remote MQTT client
    # @overload publishAcknowledgeHandler(handler)
    #   @yield the handler
    # @return [self]
    def publish_acknowledge_handler
      if true
        @j_del.java_method(:publishAcknowledgeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_acknowledge_handler()"
      end
    end
    #  Sends the SUBACK message to the remote MQTT client
    # @overload subscribeAcknowledge(subscribeMessageId,grantedQoSLevels)
    #   @param [Fixnum] subscribeMessageId identifier of the SUBSCRIBE message to acknowledge
    #   @param [Array<:AT_MOST_ONCE,:AT_LEAST_ONCE,:EXACTLY_ONCE,:FAILURE>] grantedQoSLevels granted QoS levels for the requested topics
    # @return [self]
    def subscribe_acknowledge(*args)
      if args[0].class == Fixnum && args[1].class == Array && !block_given?
        @j_del.java_method(:subscribeAcknowledge, [Java::int.java_class,Java::JavaUtil::List.java_class]).call(args[0],args[1].map { |element| Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(element.to_s) })
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscribe_acknowledge(#{args[0]},#{args[1]})"
      end
    end
    # @overload protocolName()
    # @return [String] the protocol name provided by the remote MQTT client
    def protocol_name
      if !block_given?
        if @cached_protocol_name != nil
          return @cached_protocol_name
        end
        return @cached_protocol_name = @j_del.java_method(:protocolName, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling protocol_name()"
      end
    end
    #  Sends the CONNACK message to the remote MQTT client rejecting the connection
    #  request with specified return code. See {::VertxMqtt::MqttEndpoint#accept} for accepting connection
    # @overload reject(returnCode)
    #   @param [:CONNECTION_ACCEPTED,:CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION,:CONNECTION_REFUSED_IDENTIFIER_REJECTED,:CONNECTION_REFUSED_SERVER_UNAVAILABLE,:CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD,:CONNECTION_REFUSED_NOT_AUTHORIZED] returnCode the connect return code
    # @return [self]
    def reject(*args)
      if args[0].class == Symbol && !block_given?
        @j_del.java_method(:reject, [Java::IoNettyHandlerCodecMqtt::MqttConnectReturnCode.java_class]).call(Java::IoNettyHandlerCodecMqtt::MqttConnectReturnCode.valueOf(args[0].to_s))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reject(#{args[0]})"
      end
    end
    # @overload keepAliveTimeSeconds()
    # @return [Fixnum] the keep alive timeout (in seconds) specified by the remote MQTT client
    def keep_alive_time_seconds
      if !block_given?
        if @cached_keep_alive_time_seconds != nil
          return @cached_keep_alive_time_seconds
        end
        return @cached_keep_alive_time_seconds = @j_del.java_method(:keepAliveTimeSeconds, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling keep_alive_time_seconds()"
      end
    end
    # @overload protocolVersion()
    # @return [Fixnum] the protocol version required by the remote MQTT client
    def protocol_version
      if !block_given?
        if @cached_protocol_version != nil
          return @cached_protocol_version
        end
        return @cached_protocol_version = @j_del.java_method(:protocolVersion, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling protocol_version()"
      end
    end
    #  Close the endpoint, so the connection with remote MQTT client
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Set client identifier if not provided by the remote MQTT client (zero-bytes)
    # @overload setClientIdentifier(clientIdentifier)
    #   @param [String] clientIdentifier the client identifier
    # @return [self]
    def set_client_identifier(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setClientIdentifier, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_client_identifier(#{args[0]})"
      end
    end
    # @overload remoteAddress()
    # @return [::Vertx::SocketAddress] the remote address for this socket
    def remote_address
      if !block_given?
        if @cached_remote_address != nil
          return @cached_remote_address
        end
        return @cached_remote_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:remoteAddress, []).call(),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remote_address()"
      end
    end
    #  Set the pubrel handler on the MQTT endpoint. This handler is called when a PUBREL
    #  message is received by the remote MQTT client
    # @overload publishReleaseHandler(handler)
    #   @yield the handler
    # @return [self]
    def publish_release_handler
      if true
        @j_del.java_method(:publishReleaseHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_release_handler()"
      end
    end
    # @overload isAutoKeepAlive()
    # @return [true,false] the auto keep alive status (sending ping response)
    def auto_keep_alive?
      if !block_given?
        return @j_del.java_method(:isAutoKeepAlive, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling auto_keep_alive?()"
      end
    end
    #  Sends the PUBREC message to the remote MQTT client
    # @overload publishReceived(publishMessageId)
    #   @param [Fixnum] publishMessageId identifier of the PUBLISH message to acknowledge
    # @return [self]
    def publish_received(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:publishReceived, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_received(#{args[0]})"
      end
    end
    #  Set a disconnect handler on the MQTT endpoint. This handler is called when a DISCONNECT
    #  message is received by the remote MQTT client
    # @overload disconnectHandler(handler)
    #   @yield the handler
    # @return [self]
    def disconnect_handler
      if true
        @j_del.java_method(:disconnectHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling disconnect_handler()"
      end
    end
    # @overload will()
    # @return [Hash{String => Object}] the Will information as provided by the remote MQTT client
    def will
      if !block_given?
        if @cached_will != nil
          return @cached_will
        end
        return @cached_will = @j_del.java_method(:will, []).call() != nil ? JSON.parse(@j_del.java_method(:will, []).call().toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling will()"
      end
    end
    # @overload clientIdentifier()
    # @return [String] the client identifier as provided by the remote MQTT client
    def client_identifier
      if !block_given?
        if @cached_client_identifier != nil
          return @cached_client_identifier
        end
        return @cached_client_identifier = @j_del.java_method(:clientIdentifier, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling client_identifier()"
      end
    end
    #  Set a subscribe handler on the MQTT endpoint. This handler is called when a SUBSCRIBE
    #  message is received by the remote MQTT client
    # @overload subscribeHandler(handler)
    #   @yield the handler
    # @return [self]
    def subscribe_handler
      if true
        @j_del.java_method(:subscribeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxMqtt::MqttSubscribeMessage)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscribe_handler()"
      end
    end
    # @overload isSubscriptionAutoAck()
    # @return [true,false] true when auto acknowledge status for subscription/unsubscription requests
    def subscription_auto_ack?
      if !block_given?
        return @j_del.java_method(:isSubscriptionAutoAck, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscription_auto_ack?()"
      end
    end
    # @overload isCleanSession()
    # @return [true,false] true when clean session is requested by the remote MQTT client
    def clean_session?
      if !block_given?
        if @cached_is_clean_session != nil
          return @cached_is_clean_session
        end
        return @cached_is_clean_session = @j_del.java_method(:isCleanSession, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clean_session?()"
      end
    end
    #  Set a close handler. This will be called when the MQTT endpoint is closed
    # @overload closeHandler(handler)
    #   @yield the handler
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    #  Sends the CONNACK message to the remote MQTT client with "connection accepted"
    #  return code. See {::VertxMqtt::MqttEndpoint#reject} for refusing connection
    # @overload accept()
    # @overload accept(sessionPresent)
    #   @param [true,false] sessionPresent if a previous session is present
    # @return [self]
    def accept(*args)
      if !block_given? && args[0] == nil
        @j_del.java_method(:accept, []).call()
        return self
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:accept, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling accept(#{args[0]})"
      end
    end
    #  Sends the UNSUBACK message to the remote MQTT client
    # @overload unsubscribeAcknowledge(unsubscribeMessageId)
    #   @param [Fixnum] unsubscribeMessageId identifier of the UNSUBSCRIBE message to acknowledge
    # @return [self]
    def unsubscribe_acknowledge(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:unsubscribeAcknowledge, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unsubscribe_acknowledge(#{args[0]})"
      end
    end
    #  Enable/disable auto keep alive (sending ping response)
    # @overload autoKeepAlive(isAutoKeepAlive)
    #   @param [true,false] isAutoKeepAlive auto keep alive
    # @return [self]
    def auto_keep_alive(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:autoKeepAlive, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling auto_keep_alive(#{args[0]})"
      end
    end
    # @overload localAddress()
    # @return [::Vertx::SocketAddress] the local address for this socket
    def local_address
      if !block_given?
        if @cached_local_address != nil
          return @cached_local_address
        end
        return @cached_local_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:localAddress, []).call(),::Vertx::SocketAddress)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling local_address()"
      end
    end
    #  Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
    # @overload publish(topic,payload,qosLevel,isDup,isRetain,publishSentHandler)
    #   @param [String] topic topic on which the message is published
    #   @param [::Vertx::Buffer] payload message payload
    #   @param [:AT_MOST_ONCE,:AT_LEAST_ONCE,:EXACTLY_ONCE,:FAILURE] qosLevel QoS level
    #   @param [true,false] isDup if the message is a duplicate
    #   @param [true,false] isRetain if the message needs to be retained
    #   @yield handler called after PUBLISH packet sent with a packetId
    # @overload publish(topic,payload,qosLevel,isDup,isRetain,messageId,publishSentHandler)
    #   @param [String] topic topic on which the message is published
    #   @param [::Vertx::Buffer] payload message payload
    #   @param [:AT_MOST_ONCE,:AT_LEAST_ONCE,:EXACTLY_ONCE,:FAILURE] qosLevel QoS level
    #   @param [true,false] isDup if the message is a duplicate
    #   @param [true,false] isRetain if the message needs to be retained
    #   @param [Fixnum] messageId message ID
    #   @yield handler called after PUBLISH packet sent with a packetId
    # @return [self]
    def publish(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Symbol && (args[3].class == TrueClass || args[3].class == FalseClass) && (args[4].class == TrueClass || args[4].class == FalseClass) && true && args[5] == nil
        if (block_given?)
          @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoNettyHandlerCodecMqtt::MqttQoS.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(args[2].to_s),args[3],args[4],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoNettyHandlerCodecMqtt::MqttQoS.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(args[2].to_s),args[3],args[4],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Symbol && (args[3].class == TrueClass || args[3].class == FalseClass) && (args[4].class == TrueClass || args[4].class == FalseClass) && args[5].class == Fixnum && true
        if (block_given?)
          @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoNettyHandlerCodecMqtt::MqttQoS.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(args[2].to_s),args[3],args[4],args[5],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoNettyHandlerCodecMqtt::MqttQoS.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(args[2].to_s),args[3],args[4],args[5],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]},#{args[5]})"
      end
    end
    #  Sends the PUBACK message to the remote MQTT client
    # @overload publishAcknowledge(publishMessageId)
    #   @param [Fixnum] publishMessageId identifier of the PUBLISH message to acknowledge
    # @return [self]
    def publish_acknowledge(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:publishAcknowledge, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_acknowledge(#{args[0]})"
      end
    end
    #  Set the publish handler on the MQTT endpoint. This handler is called when a PUBLISH
    #  message is received by the remote MQTT client
    # @overload publishHandler(handler)
    #   @yield the handler
    # @return [self]
    def publish_handler
      if true
        @j_del.java_method(:publishHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxMqtt::MqttPublishMessage)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_handler()"
      end
    end
    #  Enable/disable publishing (in/out) auto acknowledge
    # @overload publishAutoAck(isPublishAutoAck)
    #   @param [true,false] isPublishAutoAck auto acknowledge status
    # @return [self]
    def publish_auto_ack(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:publishAutoAck, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_auto_ack(#{args[0]})"
      end
    end
    # @overload lastMessageId()
    # @return [Fixnum] the message identifier used for last published message
    def last_message_id
      if !block_given?
        if @cached_last_message_id != nil
          return @cached_last_message_id
        end
        return @cached_last_message_id = @j_del.java_method(:lastMessageId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling last_message_id()"
      end
    end
    #  Set an exception handler. This will be called when an error at protocol level happens
    # @overload exceptionHandler(handler)
    #   @yield the handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    # @overload isSsl()
    # @return [true,false] true if this {::VertxMqtt::MqttEndpoint} is encrypted via SSL/TLS.
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSsl, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ssl?()"
      end
    end
  end
end
