require 'vertx-sql-client/sql_connection'
require 'vertx/vertx'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/tuple'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.mysqlclient.MySQLConnection
module VertxMysqlClient
  #  A connection to MySQL server.
  class MySQLConnection < ::VertxSqlClient::SqlConnection
    # @private
    # @param j_del [::VertxMysqlClient::MySQLConnection] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMysqlClient::MySQLConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MySQLConnection
    end
    def @@j_api_type.wrap(obj)
      MySQLConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMysqlclient::MySQLConnection.java_class
    end
    #  Send a SET_OPTION command to set options for the current connection.
    # @overload setOption(option,handler)
    #   @param [:MYSQL_OPTION_MULTI_STATEMENTS_ON,:MYSQL_OPTION_MULTI_STATEMENTS_OFF] option the options to set
    #   @yield the handler notified with the execution result
    # @return [self]
    def set_option(*args)
      if args[0].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:setOption, [Java::IoVertxMysqlclient::MySQLSetOption.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxMysqlclient::MySQLSetOption.valueOf(args[0].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:setOption, [Java::IoVertxMysqlclient::MySQLSetOption.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxMysqlclient::MySQLSetOption.valueOf(args[0].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_option(#{args[0]})"
      end
    end
    # @overload prepare(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @return [self]
    def prepare(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::PreparedQuery.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepare(#{args[0]})"
      end
    end
    #  Send a RESET_CONNECTION command to reset the session state.
    # @overload resetConnection(handler)
    #   @yield the handler notified with the execution result
    # @return [self]
    def reset_connection
      if true
        if (block_given?)
          @j_del.java_method(:resetConnection, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resetConnection, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reset_connection()"
      end
    end
    #  Send a DEBUG command to dump debug information to the server's stdout.
    # @overload debug(handler)
    #   @yield the handler notified with the execution result
    # @return [self]
    def debug
      if true
        if (block_given?)
          @j_del.java_method(:debug, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:debug, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling debug()"
      end
    end
    #  Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
    # @overload changeUser(options,handler)
    #   @param [Hash{String => Object}] options authentication options
    #   @yield the handler
    # @return [self]
    def change_user(*args)
      if args[0].class == Hash && true
        if (block_given?)
          @j_del.java_method(:changeUser, [Java::IoVertxMysqlclient::MySQLAuthOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxMysqlclient::MySQLAuthOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:changeUser, [Java::IoVertxMysqlclient::MySQLAuthOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxMysqlclient::MySQLAuthOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling change_user(#{args[0]})"
      end
    end
    #  Send a STATISTICS command to get a human readable string of the server internal status.
    # @overload getInternalStatistics(handler)
    #   @yield the handler notified with the execution result
    # @return [self]
    def get_internal_statistics
      if true
        if (block_given?)
          @j_del.java_method(:getInternalStatistics, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getInternalStatistics, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_internal_statistics()"
      end
    end
    #  Send a INIT_DB command to change the default schema of the connection.
    # @overload specifySchema(schemaName,handler)
    #   @param [String] schemaName name of the schema to change to
    #   @yield the handler notified with the execution result
    # @return [self]
    def specify_schema(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:specifySchema, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:specifySchema, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling specify_schema(#{args[0]})"
      end
    end
    #  Send a PING command to check if the server is alive.
    # @overload ping(handler)
    #   @yield the handler notified when the server responses to client
    # @return [self]
    def ping
      if true
        if (block_given?)
          @j_del.java_method(:ping, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:ping, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ping()"
      end
    end
    # @overload query(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @return [self]
    def query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query(#{args[0]})"
      end
    end
    # @overload closeHandler(handler)
    #   @yield 
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Like {::VertxMysqlClient::MySQLConnection#connect} with options build from <code>connectionUri</code>.
    # @overload connect(vertx,connectOptions,handler)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] connectOptions the options for the connection
    #   @yield the handler called with the connection or the failure
    # @overload connect(vertx,connectionUri,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @yield 
    # @return [void]
    def self.connect(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && true
        if (block_given?)
          return Java::IoVertxMysqlclient::MySQLConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxMysqlclient::MySQLConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,Java::IoVertxMysqlclient::MySQLConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMysqlClient::MySQLConnection) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxMysqlclient::MySQLConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxMysqlclient::MySQLConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,Java::IoVertxMysqlclient::MySQLConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMysqlClient::MySQLConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMysqlClient::MySQLConnection.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && true
        if (block_given?)
          return Java::IoVertxMysqlclient::MySQLConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMysqlClient::MySQLConnection) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxMysqlclient::MySQLConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMysqlClient::MySQLConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMysqlClient::MySQLConnection.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect(#{args[0]},#{args[1]})"
      end
    end
    # @overload preparedQuery(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @overload preparedQuery(sql,arguments,handler)
    #   @param [String] sql 
    #   @param [::VertxSqlClient::Tuple] arguments 
    #   @yield 
    # @return [self]
    def prepared_query(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepared_query(#{args[0]},#{args[1]})"
      end
    end
  end
end
