require 'vertx-shell/process'
require 'vertx-shell/tty'
require 'vertx-shell/session'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.system.Job
module VertxShell
  #  A job executed in a {::VertxShell::JobController}, grouping one or several process.<p/>
  # 
  #  The job life cycle can be controlled with the {::VertxShell::Job#run}, {::VertxShell::Job#resume} and {::VertxShell::Job#suspend} and {::VertxShell::Job#interrupt}
  #  methods.
  class Job
    # @private
    # @param j_del [::VertxShell::Job] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::Job] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Job
    end
    def @@j_api_type.wrap(obj)
      Job.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellSystem::Job.java_class
    end
    #  Resume the job.
    # @overload suspend()
    # @return [self]
    def suspend
      if !block_given?
        @j_del.java_method(:suspend, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling suspend()"
      end
    end
    #  Resume the job.
    # @overload resume()
    # @overload resume(foreground)
    #   @param [true,false] foreground true when the job is resumed in foreground
    # @return [self]
    def resume(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:resume, []).call(),::VertxShell::Job)
      elsif (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:resume, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume(#{args[0]})"
      end
    end
    # @overload process()
    # @return [::VertxShell::Process] the first process in the job
    def process
      if !block_given?
        if @cached_process != nil
          return @cached_process
        end
        return @cached_process = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:process, []).call(),::VertxShell::Process)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling process()"
      end
    end
    # @overload line()
    # @return [String] the execution line of the job, i.e the shell command line that launched this job
    def line
      if !block_given?
        return @j_del.java_method(:line, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling line()"
      end
    end
    #  Run the job, before running the job a  must be set.
    # @overload run()
    # @return [self]
    def run
      if !block_given?
        @j_del.java_method(:run, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling run()"
      end
    end
    # @overload lastStopped()
    # @return [Fixnum] when the job was last stopped
    def last_stopped
      if !block_given?
        return @j_del.java_method(:lastStopped, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling last_stopped()"
      end
    end
    #  Set an handler called when the job terminates.
    # @overload statusUpdateHandler(handler)
    #   @yield the terminate handler
    # @return [self]
    def status_update_handler
      if true
        @j_del.java_method(:statusUpdateHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event.name.intern) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling status_update_handler()"
      end
    end
    #  Set a tty on the job.
    # @overload setTty(tty)
    #   @param [::VertxShell::Tty] tty the tty to use
    # @return [self]
    def set_tty(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setTty, [Java::IoVertxExtShellTerm::Tty.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_tty(#{args[0]})"
      end
    end
    #  Attempt to interrupt the job.
    # @overload interrupt()
    # @return [true,false] true if the job is actually interrupted
    def interrupt?
      if !block_given?
        return @j_del.java_method(:interrupt, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling interrupt?()"
      end
    end
    #  Terminate the job.
    # @overload terminate()
    # @return [void]
    def terminate
      if !block_given?
        return @j_del.java_method(:terminate, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling terminate()"
      end
    end
    #  Send the job to background.
    # @overload toBackground()
    # @return [self]
    def to_background
      if !block_given?
        @j_del.java_method(:toBackground, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_background()"
      end
    end
    #  Set a session on the job.
    # @overload setSession(session)
    #   @param [::VertxShell::Session] session the session to use
    # @return [self]
    def set_session(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setSession, [Java::IoVertxExtShellSession::Session.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_session(#{args[0]})"
      end
    end
    # @overload id()
    # @return [Fixnum] the job id
    def id
      if !block_given?
        return @j_del.java_method(:id, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling id()"
      end
    end
    #  Send the job to foreground.
    # @overload toForeground()
    # @return [self]
    def to_foreground
      if !block_given?
        @j_del.java_method(:toForeground, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to_foreground()"
      end
    end
    # @overload status()
    # @return [:READY,:RUNNING,:STOPPED,:TERMINATED] the job exec status
    def status
      if !block_given?
        return @j_del.java_method(:status, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling status()"
      end
    end
  end
end
