require 'vertx-shell/term_server'
require 'vertx/vertx'
require 'vertx-shell/shell'
require 'vertx-shell/command_resolver'
require 'vertx-shell/term'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.ShellServer
module VertxShell
  #  The shell server.<p/>
  # 
  #  A shell server is associated with a collection of : the {::VertxShell::ShellServer#register_term_server}
  #  method registers a term server. Term servers life cycle are managed by this server.<p/>
  # 
  #  When a  receives an incoming connection, a  instance is created and
  #  associated with this connection.<p/>
  # 
  #  The {::VertxShell::ShellServer#create_shell} method can be used to create  instance for testing purposes.
  class ShellServer
    # @private
    # @param j_del [::VertxShell::ShellServer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::ShellServer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ShellServer
    end
    def @@j_api_type.wrap(obj)
      ShellServer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShell::ShellServer.java_class
    end
    #  Create a new shell, the returned shell should be closed explicitely.
    # @overload createShell()
    # @overload createShell(term)
    #   @param [::VertxShell::Term] term the shell associated terminal
    # @return [::VertxShell::Shell] the created shell
    def create_shell(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createShell, []).call(),::VertxShell::Shell)
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createShell, [Java::IoVertxExtShellTerm::Term.java_class]).call(args[0].j_del),::VertxShell::Shell)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_shell(#{args[0]})"
      end
    end
    #  Register a command resolver for this server.
    # @overload registerCommandResolver(resolver)
    #   @param [::VertxShell::CommandResolver] resolver the resolver
    # @return [self]
    def register_command_resolver(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:registerCommandResolver, [Java::IoVertxExtShellCommand::CommandResolver.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register_command_resolver(#{args[0]})"
      end
    end
    #  Register a term server to this shell server, the term server lifecycle methods are managed by this shell server.
    # @overload registerTermServer(termServer)
    #   @param [::VertxShell::TermServer] termServer the term server to add
    # @return [self]
    def register_term_server(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:registerTermServer, [Java::IoVertxExtShellTerm::TermServer.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register_term_server(#{args[0]})"
      end
    end
    #  Create a new shell server with default options.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx
    #   @param [Hash{String => Object}] options the options
    # @return [::VertxShell::ShellServer] the created shell server
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShell::ShellServer.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxShell::ShellServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShell::ShellServer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtShell::ShellServerOptions.java_class]).call(args[0].j_del,Java::IoVertxExtShell::ShellServerOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxShell::ShellServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Called when a new shell is created. Can be used to prepopulate the shell session with objects
    #  or set the prompt.
    # @overload shellHandler(shellHandler)
    #   @yield handler for getting notified when the server creates a new shell.
    # @return [void]
    def shell_handler
      if true
        return @j_del.java_method(:shellHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxShell::Shell)) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling shell_handler()"
      end
    end
    #  Close the shell server, this is an asynchronous close.
    # @overload close()
    # @overload close(completionHandler)
    #   @yield handler for getting notified when service is stopped
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Start the shell service, this is an asynchronous start.
    # @overload listen()
    # @overload listen(listenHandler)
    #   @yield handler for getting notified when service is started
    # @return [self]
    def listen
      if !block_given?
        @j_del.java_method(:listen, []).call()
        return self
      elsif true
        if (block_given?)
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listen()"
      end
    end
  end
end
