require 'vertx-shell/shell_server'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.ShellService
module VertxShell
  #  The shell service, provides a remotely accessible shell available via Telnet or SSH according to the
  #  {Hash{String => Object}} configuration.<p/>
  # 
  #  The shell service will expose commands using {::VertxShell::CommandResolver} on the classpath and
  #  the shared command registry for the Vert.x instance.
  class ShellService
    # @private
    # @param j_del [::VertxShell::ShellService] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::ShellService] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ShellService
    end
    def @@j_api_type.wrap(obj)
      ShellService.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShell::ShellService.java_class
    end
    # @overload server()
    # @return [::VertxShell::ShellServer] the shell server
    def server
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:server, []).call(),::VertxShell::ShellServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling server()"
      end
    end
    #  Stop the shell service, this is an asynchronous start.
    # @overload stop()
    # @overload stop(stopHandler)
    #   @yield handler for getting notified when service is stopped
    # @return [void]
    def stop
      if !block_given?
        return @j_del.java_method(:stop, []).call()
      elsif true
        if (block_given?)
          return @j_del.java_method(:stop, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:stop, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stop()"
      end
    end
    #  Start the shell service, this is an asynchronous start.
    # @overload start()
    # @overload start(startHandler)
    #   @yield handler for getting notified when service is started
    # @return [void]
    def start
      if !block_given?
        return @j_del.java_method(:start, []).call()
      elsif true
        if (block_given?)
          return @j_del.java_method(:start, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:start, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling start()"
      end
    end
    #  Create a new shell service.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] options the service config options
    # @return [::VertxShell::ShellService] the shell service
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShell::ShellService.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxShell::ShellService)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShell::ShellService.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtShell::ShellServiceOptions.java_class]).call(args[0].j_del,Java::IoVertxExtShell::ShellServiceOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxShell::ShellService)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
  end
end
