require 'vertx-sql/sql_row_stream'
require 'vertx-sql/sql_operations'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.sql.SQLConnection
module VertxSql
  #  Represents a connection to a SQL database
  class SQLConnection
    include ::VertxSql::SQLOperations
    # @private
    # @param j_del [::VertxSql::SQLConnection] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSql::SQLConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SQLConnection
    end
    def @@j_api_type.wrap(obj)
      SQLConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtSql::SQLConnection.java_class
    end
    #  Rolls back all changes made since the previous commit/rollback.
    # @overload rollback(handler)
    #   @yield the handler called when this operation completes.
    # @return [self]
    def rollback
      if true
        if (block_given?)
          @j_del.java_method(:rollback, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:rollback, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling rollback()"
      end
    end
    #  Attempts to change the transaction isolation level for this Connection object to the one given.
    # 
    #  The constants defined in the interface Connection are the possible transaction isolation levels.
    # @overload setTransactionIsolation(isolation,handler)
    #   @param [:READ_UNCOMMITTED,:READ_COMMITTED,:REPEATABLE_READ,:SERIALIZABLE,:NONE] isolation the level of isolation
    #   @yield the handler called when this operation completes.
    # @return [self]
    def set_transaction_isolation(*args)
      if args[0].class == Symbol && true
        if (block_given?)
          @j_del.java_method(:setTransactionIsolation, [Java::IoVertxExtSql::TransactionIsolation.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtSql::TransactionIsolation.valueOf(args[0].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:setTransactionIsolation, [Java::IoVertxExtSql::TransactionIsolation.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxExtSql::TransactionIsolation.valueOf(args[0].to_s),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_transaction_isolation(#{args[0]})"
      end
    end
    #  Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
    #  statement with the given parameters
    # @overload updateWithParams(sql,params,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>INSERT INTO table ...</code>
    #   @param [Array<String,Object>] params these are the parameters to fill the statement.
    #   @yield the handler which is called once the operation completes.
    # @return [self]
    def update_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:updateWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:updateWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::UpdateResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
    # @overload query(sql,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::ResultSet))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query(#{args[0]})"
      end
    end
    #  Batch simple SQL strings and execute the batch where the async result contains a array of Integers.
    # @overload batch(sqlStatements,handler)
    #   @param [Array<String>] sqlStatements sql statement
    #   @yield the result handler
    # @return [self]
    def batch(*args)
      if args[0].class == Array && true
        if (block_given?)
          @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling batch(#{args[0]})"
      end
    end
    #  Commits all changes made since the previous commit/rollback.
    # @overload commit(handler)
    #   @yield the handler called when this operation completes.
    # @return [self]
    def commit
      if true
        if (block_given?)
          @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling commit()"
      end
    end
    #  Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
    #  getting a connection from the pool (this object) and return it back after the execution. Only the first result
    #  from the result set is returned.
    # @overload querySingle(sql,handler)
    #   @param [String] sql the statement to execute
    #   @yield the result handler
    # @return [self]
    def query_single(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:querySingle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:querySingle, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_single(#{args[0]})"
      end
    end
    #  Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
    #  statement.
    # @overload update(sql,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>INSERT INTO table ...</code>
    #   @yield the handler which is called once the operation completes.
    # @return [self]
    def update(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:update, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:update, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::UpdateResult))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling update(#{args[0]})"
      end
    end
    #  Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
    #  boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
    #  Only the first result from the result set is returned.
    # @overload querySingleWithParams(sql,arguments,handler)
    #   @param [String] sql the statement to execute
    #   @param [Array<String,Object>] arguments the arguments
    #   @yield the result handler
    # @return [self]
    def query_single_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:querySingleWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:querySingleWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_single_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
    # @overload queryStreamWithParams(sql,params,handler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @param [Array<String,Object>] params these are the parameters to fill the statement.
    #   @yield the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
    # @return [self]
    def query_stream_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:queryStreamWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queryStreamWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSql::SQLRowStream.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_stream_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Executes the given SQL statement
    # @overload execute(sql,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
    #   @yield the handler which is called once this operation completes.
    # @return [self]
    def execute(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:execute, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:execute, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute(#{args[0]})"
      end
    end
    #  Batch a callable statement with all entries from the args list. Each entry is a batch.
    #  The size of the lists inArgs and outArgs MUST be the equal.
    #  The operation completes with the execution of the batch where the async result contains a array of Integers.
    # @overload batchCallableWithParams(sqlStatement,inArgs,outArgs,handler)
    #   @param [String] sqlStatement sql statement
    #   @param [Array<Array<String,Object>>] inArgs the callable statement input arguments
    #   @param [Array<Array<String,Object>>] outArgs the callable statement output arguments
    #   @yield the result handler
    # @return [self]
    def batch_callable_with_params(*args)
      if args[0].class == String && args[1].class == Array && args[2].class == Array && true
        if (block_given?)
          @j_del.java_method(:batchCallableWithParams, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| ::Vertx::Util::Utils.to_json_array(element) },args[2].map { |element| ::Vertx::Util::Utils.to_json_array(element) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:batchCallableWithParams, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| ::Vertx::Util::Utils.to_json_array(element) },args[2].map { |element| ::Vertx::Util::Utils.to_json_array(element) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling batch_callable_with_params(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Batch a prepared statement with all entries from the args list. Each entry is a batch.
    #  The operation completes with the execution of the batch where the async result contains a array of Integers.
    # @overload batchWithParams(sqlStatement,args,handler)
    #   @param [String] sqlStatement sql statement
    #   @param [Array<Array<String,Object>>] args the prepared statement arguments
    #   @yield the result handler
    # @return [self]
    def batch_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:batchWithParams, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| ::Vertx::Util::Utils.to_json_array(element) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:batchWithParams, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| ::Vertx::Util::Utils.to_json_array(element) },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling batch_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Sets a connection wide query timeout.
    # 
    #  It can be over written at any time and becomes active on the next query call.
    # @overload setQueryTimeout(timeoutInSeconds)
    #   @param [Fixnum] timeoutInSeconds the max amount of seconds the query can take to execute.
    # @return [self]
    def set_query_timeout(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setQueryTimeout, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_query_timeout(#{args[0]})"
      end
    end
    #  Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
    # @overload call(sql,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>{call getEmpName}</code>.
    #   @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def call(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:call, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:call, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::ResultSet))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling call(#{args[0]})"
      end
    end
    #  Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
    # @overload queryWithParams(sql,params,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @param [Array<String,Object>] params these are the parameters to fill the statement.
    #   @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def query_with_params(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:queryWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queryWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::ResultSet))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_with_params(#{args[0]},#{args[1]})"
      end
    end
    #  Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
    # 
    #  The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
    #  takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
    # 
    #  <pre>
    #    params = [VALUE1, VALUE2, null]
    #    outputs = [null, null, "VARCHAR"]
    #  </pre>
    # @overload callWithParams(sql,params,outputs,resultHandler)
    #   @param [String] sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
    #   @param [Array<String,Object>] params these are the parameters to fill the statement.
    #   @param [Array<String,Object>] outputs these are the outputs to fill the statement.
    #   @yield the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
    # @return [self]
    def call_with_params(*args)
      if args[0].class == String && args[1].class == Array && args[2].class == Array && true
        if (block_given?)
          @j_del.java_method(:callWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),::Vertx::Util::Utils.to_json_array(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:callWithParams, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCoreJson::JsonArray.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],::Vertx::Util::Utils.to_json_array(args[1]),::Vertx::Util::Utils.to_json_array(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxExtSql::ResultSet))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling call_with_params(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Sets the auto commit flag for this connection. True by default.
    # @overload setAutoCommit(autoCommit,resultHandler)
    #   @param [true,false] autoCommit the autoCommit flag, true by default.
    #   @yield the handler which is called once this operation completes.
    # @return [self]
    def set_auto_commit(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && true
        if (block_given?)
          @j_del.java_method(:setAutoCommit, [Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:setAutoCommit, [Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_auto_commit(#{args[0]})"
      end
    end
    #  Attempts to return the transaction isolation level for this Connection object to the one given.
    # @overload getTransactionIsolation(handler)
    #   @yield the handler called when this operation completes.
    # @return [self]
    def get_transaction_isolation
      if true
        if (block_given?)
          @j_del.java_method(:getTransactionIsolation, [Java::IoVertxCore::Handler.java_class]).call(nil)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getTransactionIsolation, [Java::IoVertxCore::Handler.java_class]).call(nil)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::java_enum_type(Java::IoVertxExtSql::TransactionIsolation))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_transaction_isolation()"
      end
    end
    #  Sets the desired options to be applied to the current connection when statements are executed.
    # 
    #  The options are not applied globally but applicable to the current connection. For example changing the transaction
    #  isolation level will only affect statements run on this connection and not future or current connections acquired
    #  from the connection pool.
    # 
    #  This method is not async in nature since the apply will only happen at the moment a query is run.
    # @overload setOptions(options)
    #   @param [Hash{String => Object}] options the options to modify the unwrapped connection.
    # @return [self]
    def set_options(*args)
      if args[0].class == Hash && !block_given?
        @j_del.java_method(:setOptions, [Java::IoVertxExtSql::SQLOptions.java_class]).call(Java::IoVertxExtSql::SQLOptions.new(::Vertx::Util::Utils.to_json_object(args[0])))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_options(#{args[0]})"
      end
    end
    #  Closes the connection. Important to always close the connection when you are done so it's returned to the pool.
    # @overload close()
    # @overload close(handler)
    #   @yield the handler called when this operation completes.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
    # @overload queryStream(sql,handler)
    #   @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    #   @yield the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
    # @return [self]
    def query_stream(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:queryStream, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:queryStream, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSql::SQLRowStream) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSql::SQLRowStream.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query_stream(#{args[0]})"
      end
    end
  end
end
