require 'vertx-bridge-common/base_bridge_event'
require 'vertx/future'
require 'vertx/net_socket'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.eventbus.bridge.tcp.BridgeEvent
module VertxTcpEventbusBridge
  #  Represents an event that occurs on the event bus bridge.
  #  <p>
  #  Please consult the documentation for a full explanation.
  class BridgeEvent < ::VertxBridgeCommon::BaseBridgeEvent
    # @private
    # @param j_del [::VertxTcpEventbusBridge::BridgeEvent] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxTcpEventbusBridge::BridgeEvent] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == BridgeEvent
    end
    def @@j_api_type.wrap(obj)
      BridgeEvent.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtEventbusBridgeTcp::BridgeEvent.java_class
    end
    # @overload future()
    # @return [::Vertx::Future] the  associated with this promise, it can be used to be aware of the promise completion
    def future
      if !block_given?
        if @cached_future != nil
          return @cached_future
        end
        return @cached_future = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:future, []).call(),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling future()"
      end
    end
    #  Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
    #  no message involved.
    # @overload setRawMessage(message)
    #   @param [Hash{String => Object}] message the raw message
    # @return [self]
    def set_raw_message(*args)
      if args[0].class == Hash && !block_given?
        @j_del.java_method(:setRawMessage, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_raw_message(#{args[0]})"
      end
    end
    #  Like {::Vertx::Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
    #  an IllegalStateException, it returns <code>true</code> otherwise.
    # @overload tryComplete(result)
    #   @param [true,false] result the result
    # @return [true,false] <code>false</code> when the future is already completed
    def try_complete?(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return @j_del.java_method(:tryComplete, [Java::JavaLang::Boolean.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling try_complete?(#{args[0]})"
      end
    end
    #  Get the SockJSSocket instance corresponding to the event
    # @overload socket()
    # @return [::Vertx::NetSocket] the SockJSSocket instance
    def socket
      if !block_given?
        if @cached_socket != nil
          return @cached_socket
        end
        return @cached_socket = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:socket, []).call(),::Vertx::NetSocket)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling socket()"
      end
    end
    #  Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
    #  <p/>
    #  Any handler set on the associated promise will be called.
    # @overload complete(result)
    #   @param [true,false] result the result
    # @return [void]
    def complete(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return @j_del.java_method(:complete, [Java::JavaLang::Boolean.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling complete(#{args[0]})"
      end
    end
  end
end
