require 'vertx-web-client/response_predicate_result'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.client.predicate.ErrorConverter
module VertxWebClient
  #  Converts a {::VertxWebClient::ResponsePredicateResult} to a <code>Throwable</code> describing the error.
  class ErrorConverter
    # @private
    # @param j_del [::VertxWebClient::ErrorConverter] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebClient::ErrorConverter] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ErrorConverter
    end
    def @@j_api_type.wrap(obj)
      ErrorConverter.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebClientPredicate::ErrorConverter.java_class
    end
    # @overload apply(result)
    #   @param [::VertxWebClient::ResponsePredicateResult] result 
    # @return [Exception]
    def apply(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.from_throwable(@j_del.java_method(:apply, [Java::IoVertxExtWebClientPredicate::ResponsePredicateResult.java_class]).call(args[0].j_del))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling apply(#{args[0]})"
      end
    end
    #  Creates a full {::VertxWebClient::ErrorConverter}, that will passed a predicate result with the response body.
    # 
    #  <p>The <code>converter</code> function will be invoked <em>after</em> the HTTP response body is received.
    # @overload createFullBody(converter)
    #   @yield a function creating a Throwable from a {::VertxWebClient::ResponsePredicateResult}
    # @return [::VertxWebClient::ErrorConverter]
    def self.create_full_body(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ErrorConverter.java_method(:createFullBody, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_throwable(yield(::Vertx::Util::Utils.safe_create(event,::VertxWebClient::ResponsePredicateResult))) unless !block_given? })),::VertxWebClient::ErrorConverter)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_full_body(#{args[0]})"
      end
    end
    # @overload requiresBody()
    # @return [true,false] <code>true</code> when the converter wants to process the request body.
    def requires_body?
      if !block_given?
        return @j_del.java_method(:requiresBody, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling requires_body?()"
      end
    end
    #  Creates a full {::VertxWebClient::ErrorConverter}, that will passed a predicate result with the response body.
    # 
    #  <p>The <code>converter</code> function will be invoked <em>after</em> the HTTP response body is received.
    # @overload create(converter)
    #   @yield a function creating a Throwable from a {::VertxWebClient::ResponsePredicateResult}
    # @return [::VertxWebClient::ErrorConverter]
    def self.create(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ErrorConverter.java_method(:create, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_throwable(yield(::Vertx::Util::Utils.safe_create(event,::VertxWebClient::ResponsePredicateResult))) unless !block_given? })),::VertxWebClient::ErrorConverter)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    def self.DEFAULT_CONVERTER
      ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebClientPredicate::ErrorConverter.DEFAULT_CONVERTER,::VertxWebClient::ErrorConverter)
    end
  end
end
