require 'vertx-web/route'
require 'vertx/http_server_request'
require 'vertx/vertx'
require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.Router
module VertxWeb
  #  A router receives request from an {::Vertx::HttpServer} and routes it to the first matching
  #  {::VertxWeb::Route} that it contains. A router can contain many routes.
  #  <p>
  #  Routers are also used for routing failures.
  class Router
    # @private
    # @param j_del [::VertxWeb::Router] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::Router] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Router
    end
    def @@j_api_type.wrap(obj)
      Router.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWeb::Router.java_class
    end
    #  Used to route a context to the router. Used for sub-routers. You wouldn't normally call this method directly.
    # @overload handleContext(context)
    #   @param [::VertxWeb::RoutingContext] context the routing context
    # @return [void]
    def handle_context(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handleContext, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle_context(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP DELETE request and the specified path
    # @overload delete()
    # @overload delete(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def delete(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP PUT request and the specified path
    # @overload put()
    # @overload put(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def put(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP PATCH request and the specified path
    # @overload patch()
    # @overload patch(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def patch(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:patch, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:patch, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling patch(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP HEAD request and the specified path
    # @overload head()
    # @overload head(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def head(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling head(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP TRACE request and the specified path
    # @overload trace()
    # @overload trace(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def trace(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:trace, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:trace, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling trace(#{args[0]})"
      end
    end
    #  Create a router
    # @overload router(vertx)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    # @return [::VertxWeb::Router] the router
    def self.router(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWeb::Router.java_method(:router, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxWeb::Router)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling router(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP POST request and the specified path
    # @overload post()
    # @overload post(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def post(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling post(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP GET request and the specified path
    # @overload get()
    # @overload get(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def get(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  When a Router routes are changed this handler is notified.
    #  This is useful for routes that depend on the state of the router.
    # @overload modifiedHandler(handler)
    #   @yield a notification handler that will receive this router as argument
    # @return [self]
    def modified_handler
      if true
        @j_del.java_method(:modifiedHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::Router)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling modified_handler()"
      end
    end
    #  Add a route that matches a HTTP OPTIONS request and the specified path
    # @overload options()
    # @overload options(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def options(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling options(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP CONNECT request and the specified path regex
    # @overload connectWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def connect_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:connectWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect_with_regex(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP POST request and the specified path regex
    # @overload postWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def post_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:postWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling post_with_regex(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP CONNECT request and the specified path
    # @overload connect()
    # @overload connect(path)
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def connect(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:connect, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:connect, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect(#{args[0]})"
      end
    end
    #  Add a route that matches the specified HTTP method and path regex
    # @overload routeWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @overload routeWithRegex(method,regex)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method to match
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def route_with_regex(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:routeWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      elsif args[0].class == Symbol && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:routeWithRegex, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling route_with_regex(#{args[0]},#{args[1]})"
      end
    end
    #  Add a route that matches a HTTP HEAD request and the specified path regex
    # @overload headWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def head_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling head_with_regex(#{args[0]})"
      end
    end
    #  Mount a sub router on this router
    # @overload mountSubRouter(mountPoint,subRouter)
    #   @param [String] mountPoint the mount point (path prefix) to mount it on
    #   @param [::VertxWeb::Router] subRouter the router to mount as a sub router
    # @return [self]
    def mount_sub_router(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:mountSubRouter, [Java::java.lang.String.java_class,Java::IoVertxExtWeb::Router.java_class]).call(args[0],args[1].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling mount_sub_router(#{args[0]},#{args[1]})"
      end
    end
    #  Remove all the routes from this router
    # @overload clear()
    # @return [self]
    def clear
      if !block_given?
        @j_del.java_method(:clear, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clear()"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::Vertx::HttpServerRequest] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxCoreHttp::HttpServerRequest.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Used to route a failure to the router. Used for sub-routers. You wouldn't normally call this method directly.
    # @overload handleFailure(context)
    #   @param [::VertxWeb::RoutingContext] context the routing context
    # @return [void]
    def handle_failure(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handleFailure, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle_failure(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP TRACE request and the specified path regex
    # @overload traceWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def trace_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:traceWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling trace_with_regex(#{args[0]})"
      end
    end
    # @overload getRoutes()
    # @return [Array<::VertxWeb::Route>] a list of all the routes on this router
    def get_routes
      if !block_given?
        return @j_del.java_method(:getRoutes, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxWeb::Route) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_routes()"
      end
    end
    #  Add a route that matches a HTTP PUT request and the specified path regex
    # @overload putWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def put_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:putWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_with_regex(#{args[0]})"
      end
    end
    #  Add a route that matches the specified HTTP method and path
    # @overload route()
    # @overload route(path)
    #   @param [String] path URI paths that begin with this path will match
    # @overload route(method,path)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method to match
    #   @param [String] path URI paths that begin with this path will match
    # @return [::VertxWeb::Route] the route
    def route(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:route, []).call(),::VertxWeb::Route)
      elsif args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:route, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      elsif args[0].class == Symbol && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:route, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s),args[1]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling route(#{args[0]},#{args[1]})"
      end
    end
    #  Add a route that matches a HTTP PATCH request and the specified path regex
    # @overload patchWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def patch_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:patchWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling patch_with_regex(#{args[0]})"
      end
    end
    #  Specify an handler to handle an error for a particular status code. You can use to manage general errors too using status code 500.
    #  The handler will be called when the context fails and other failure handlers didn't write the reply or when an exception is thrown inside an handler.
    #  You <b>must not</b> use {::VertxWeb::RoutingContext#next} inside the error handler
    #  This does not affect the normal failure routing logic.
    # @overload errorHandler(statusCode,errorHandler)
    #   @param [Fixnum] statusCode status code the errorHandler is capable of handle
    #   @yield error handler. Note: You <b>must not</b> use {::VertxWeb::RoutingContext#next} inside the provided handler
    # @return [self]
    def error_handler(*args)
      if args[0].class == Fixnum && true
        @j_del.java_method(:errorHandler, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling error_handler(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP OPTIONS request and the specified path regex
    # @overload optionsWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def options_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:optionsWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling options_with_regex(#{args[0]})"
      end
    end
    #  Specify a handler for any unhandled exceptions on this router. The handler will be called for exceptions thrown
    #  from handlers. This does not affect the normal failure routing logic.
    # @overload exceptionHandler(exceptionHandler)
    #   @yield the exception handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Add a route that matches a HTTP GET request and the specified path regex
    # @overload getWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def get_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_with_regex(#{args[0]})"
      end
    end
    #  Add a route that matches a HTTP DELETE request and the specified path regex
    # @overload deleteWithRegex(regex)
    #   @param [String] regex URI paths that begin with a match for this regex will match
    # @return [::VertxWeb::Route] the route
    def delete_with_regex(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:deleteWithRegex, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::Route)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete_with_regex(#{args[0]})"
      end
    end
  end
end
