require 'vertx/http_client_response'
require 'vertx/buffer'
require 'vertx/http_frame'
require 'vertx/write_stream'
require 'vertx/multi_map'
require 'vertx/http_connection'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.http.HttpClientRequest
module Vertx
  #  Represents a client-side HTTP request.
  #  <p>
  #  Instances are created by an {::Vertx::HttpClient} instance, via one of the methods corresponding to the
  #  specific HTTP methods, or the generic request methods. On creation the request will not have been written to the
  #  wire.
  #  <p>
  #  Once a request has been obtained, headers can be set on it, and data can be written to its body if required. Once
  #  you are ready to send the request, one of the {::Vertx::HttpClientRequest#end} methods should be called.
  #  <p>
  #  Nothing is actually sent until the request has been internally assigned an HTTP connection.
  #  <p>
  #  The {::Vertx::HttpClient} instance will return an instance of this class immediately, even if there are no HTTP
  #  connections available in the pool. Any requests sent before a connection is assigned will be queued
  #  internally and actually sent when an HTTP connection becomes available from the pool.
  #  <p>
  #  The headers of the request are queued for writing either when the {::Vertx::HttpClientRequest#end} method is called, or, when the first
  #  part of the body is written, whichever occurs first.
  #  <p>
  #  This class supports both chunked and non-chunked HTTP.
  #  <p>
  #  It implements {::Vertx::WriteStream} so it can be used with
  #  {::Vertx::Pump} to pump data with flow control.
  #  <p>
  #  An example of using this class is as follows:
  #  <p>
  class HttpClientRequest < ::Vertx::Future
    include ::Vertx::WriteStream
    # @private
    # @param j_del [::Vertx::HttpClientRequest] the java delegate
    def initialize(j_del)
      super(j_del, ::Vertx::HttpClientResponse.j_api_type)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::HttpClientRequest] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HttpClientRequest
    end
    def @@j_api_type.wrap(obj)
      HttpClientRequest.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreHttp::HttpClientRequest.java_class
    end
    # @overload setHandler(handler)
    #   @yield 
    # @return [self]
    def set_handler
      if true
        if (block_given?)
          @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::HttpClientResponse) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_handler()"
      end
    end
    # @overload streamId()
    # @return [Fixnum] the id of the stream of this response,  when it is not yet determined, i.e the request has not been yet sent or it is not supported HTTP/1.x
    def stream_id
      if !block_given?
        return @j_del.java_method(:streamId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stream_id()"
      end
    end
    #  This will return <code>true</code> if there are more bytes in the write queue than the value set using {::Vertx::HttpClientRequest#set_write_queue_max_size}
    # @overload writeQueueFull()
    # @return [true,false] true if write queue is full
    def write_queue_full?
      if !block_given?
        return @j_del.java_method(:writeQueueFull, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_queue_full?()"
      end
    end
    #  Set a push handler for this request.<p/>
    # 
    #  The handler is called when the client receives a <i>push promise</i> from the server. The handler can be called
    #  multiple times, for each push promise.<p/>
    # 
    #  The handler is called with a <i>read-only</i> {::Vertx::HttpClientRequest}, the following methods can be called:<p/>
    # 
    #  <ul>
    #    <li>{::Vertx::HttpClientRequest#method}</li>
    #    <li>{::Vertx::HttpClientRequest#uri}</li>
    #    <li>{::Vertx::HttpClientRequest#headers}</li>
    #    <li>{::Vertx::HttpClientRequest#get_host}</li>
    #  </ul>
    # 
    #  In addition the handler should call the {::Vertx::HttpClientRequest#set_handler} method to set an handler to
    #  process the response.<p/>
    # @overload pushHandler(handler)
    #   @yield the handler
    # @return [self]
    def push_handler
      if true
        @j_del.java_method(:pushHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientRequest)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling push_handler()"
      end
    end
    # @overload absoluteURI()
    # @return [String] the absolute URI corresponding to the the HTTP request
    def absolute_uri
      if !block_given?
        return @j_del.java_method(:absoluteURI, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling absolute_uri()"
      end
    end
    #  Set the request to follow HTTP redirects up to {Hash{String => Object}#get_max_redirects}.
    # @overload setFollowRedirects(followRedirects)
    #   @param [true,false] followRedirects <code>true</code> to follow HTTP redirects
    # @return [self]
    def set_follow_redirects(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setFollowRedirects, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_follow_redirects(#{args[0]})"
      end
    end
    # @overload getHandler()
    # @return [Proc] the handler for the result
    def get_handler
      if !block_given?
        return ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:getHandler, []).call()) { |val| val.j_del }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_handler()"
      end
    end
    # @overload setWriteQueueMaxSize(maxSize)
    #   @param [Fixnum] maxSize 
    # @return [self]
    def set_write_queue_max_size(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setWriteQueueMaxSize, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_write_queue_max_size(#{args[0]})"
      end
    end
    #  The result of the operation. This will be null if the operation failed.
    # @overload result()
    # @return [::Vertx::HttpClientResponse] the result or null if the operation failed.
    def result
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:result, []).call(),::Vertx::HttpClientResponse)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling result()"
      end
    end
    # @overload path()
    # @return [String] The path part of the uri. For example /somepath/somemorepath/someresource.foo
    def path
      if !block_given?
        return @j_del.java_method(:path, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling path()"
      end
    end
    #  Set the max number of HTTP redirects this request will follow. The default is <code>0</code> which means
    #  no redirects.
    # @overload setMaxRedirects(maxRedirects)
    #   @param [Fixnum] maxRedirects the number of HTTP redirect to follow
    # @return [self]
    def set_max_redirects(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setMaxRedirects, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_max_redirects(#{args[0]})"
      end
    end
    # @overload isChunked()
    # @return [true,false] Is the request chunked?
    def chunked?
      if !block_given?
        return @j_del.java_method(:isChunked, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling chunked?()"
      end
    end
    # @overload drainHandler(handler)
    #   @yield 
    # @return [self]
    def drain_handler
      if true
        @j_del.java_method(:drainHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling drain_handler()"
      end
    end
    #  Set a connection handler called when an HTTP connection has been established.
    # @overload connectionHandler(handler)
    #   @yield the handler
    # @return [self]
    def connection_handler
      if true
        @j_del.java_method(:connectionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpConnection)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connection_handler()"
      end
    end
    #  Write an HTTP/2 frame to the request, allowing to extend the HTTP/2 protocol.<p>
    # 
    #  The frame is sent immediatly and is not subject to flow control.<p>
    # 
    #  This method must be called after the request headers have been sent and only for the protocol HTTP/2.
    #  The {::Vertx::HttpClientRequest#send_head} should be used for this purpose.
    # @overload writeCustomFrame(frame)
    #   @param [::Vertx::HttpFrame] frame the frame to write
    # @overload writeCustomFrame(type,flags,payload)
    #   @param [Fixnum] type the 8-bit frame type
    #   @param [Fixnum] flags the 8-bit frame flags
    #   @param [::Vertx::Buffer] payload the frame payload
    # @return [self]
    def write_custom_frame(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil && args[2] == nil
        @j_del.java_method(:writeCustomFrame, [Java::IoVertxCoreHttp::HttpFrame.java_class]).call(args[0].j_del)
        return self
      elsif args[0].class == Fixnum && args[1].class == Fixnum && args[2].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:writeCustomFrame, [Java::int.java_class,Java::int.java_class,Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0],args[1],args[2].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_custom_frame(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    # @overload connection()
    # @return [::Vertx::HttpConnection] the {::Vertx::HttpConnection} associated with this request
    def connection
      if !block_given?
        if @cached_connection != nil
          return @cached_connection
        end
        return @cached_connection = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:connection, []).call(),::Vertx::HttpConnection)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connection()"
      end
    end
    #  Same as {::Vertx::HttpClientRequest#end} but with an <code>handler</code> called when the operation completes
    # @overload end(handler)
    #   @yield 
    # @overload end(chunk,handler)
    #   @param [String] chunk 
    #   @yield 
    # @overload end(chunk,handler)
    #   @param [::Vertx::Buffer] chunk 
    #   @yield 
    # @overload end(chunk,enc,handler)
    #   @param [String] chunk 
    #   @param [String] enc 
    #   @yield 
    # @return [void]
    def end(*args)
      if true && args[0] == nil && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:end, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class.method_defined?(:j_del) && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          return @j_del.java_method(:end, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end(#{args[0]},#{args[1]})"
      end
    end
    # @overload getRawMethod()
    # @return [String] the raw value of the method this request sends
    def get_raw_method
      if !block_given?
        return @j_del.java_method(:getRawMethod, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_raw_method()"
      end
    end
    #  Set the value the method to send when the method  is used.
    # @overload setRawMethod(method)
    #   @param [String] method the raw method
    # @return [self]
    def set_raw_method(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setRawMethod, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_raw_method(#{args[0]})"
      end
    end
    #  Like {::Vertx::HttpClientRequest#send_head} but with an handler after headers have been sent. The handler will be called with
    #  the HttpVersion if it can be determined or null otherwise.<p>
    # @overload sendHead()
    # @overload sendHead(completionHandler)
    #   @yield 
    # @return [self]
    def send_head
      if !block_given?
        @j_del.java_method(:sendHead, []).call()
        return self
      elsif true
        @j_del.java_method(:sendHead, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event.name.intern) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send_head()"
      end
    end
    #  Apply a <code>mapper</code> function on this future.<p>
    # 
    #  When this future succeeds, the <code>mapper</code> will be called with the completed value and this mapper
    #  returns a value. This value will complete the future returned by this method call.<p>
    # 
    #  If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
    #  will not be called.
    # @overload map(mapper)
    #   @yield the mapper function
    # @return [::Vertx::Future] the mapped future
    def map(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:map, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse))) unless !block_given? })),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling map(#{args[0]})"
      end
    end
    #  Same as {::Vertx::HttpClientRequest#write} but with an <code>handler</code> called when the operation completes
    # @overload write(data,handler)
    #   @param [::Vertx::Buffer] data 
    #   @yield 
    # @overload write(chunk,handler)
    #   @param [String] chunk 
    #   @yield 
    # @overload write(chunk,enc,handler)
    #   @param [String] chunk 
    #   @param [String] enc 
    #   @yield 
    # @return [void]
    def write(*args)
      if args[0].class.method_defined?(:j_del) && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:write, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          return @j_del.java_method(:write, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]},#{args[1]})"
      end
    end
    # @overload getHost()
    # @return [String] the request host. For HTTP/2 it returns the  pseudo header otherwise it returns the  header
    def get_host
      if !block_given?
        return @j_del.java_method(:getHost, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_host()"
      end
    end
    #  Map the failure of a future to a specific <code>value</code>.<p>
    # 
    #  When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
    # 
    #  When this future succeeds, the result will be propagated to the returned future.
    # @overload otherwise(mapper)
    #   @yield the mapper function
    # @overload otherwise(value)
    #   @param [::Vertx::HttpClientResponse] value the value that eventually completes the mapped future
    # @return [::Vertx::Future] the mapped future
    def otherwise(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del unless !block_given? })),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
      elsif args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::IoVertxCoreHttp::HttpClientResponse.java_class]).call(args[0].j_del),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling otherwise(#{args[0]})"
      end
    end
    # @overload headers()
    # @return [::Vertx::MultiMap] The HTTP headers
    def headers
      if !block_given?
        if @cached_headers != nil
          return @cached_headers
        end
        return @cached_headers = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headers, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling headers()"
      end
    end
    #  Set the request host.<p/>
    # 
    #  For HTTP/2 it sets the  pseudo header otherwise it sets the  header
    # @overload setHost(host)
    #   @param [String] host 
    # @return [self]
    def set_host(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setHost, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_host(#{args[0]})"
      end
    end
    #  Handles a failure of this Future by returning the result of another Future.
    #  If the mapper fails, then the returned future will be failed with this failure.
    # @overload recover(mapper)
    #   @yield A function which takes the exception of a failure and returns a new future.
    # @return [::Vertx::Future] A recovered future
    def recover(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:recover, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del unless !block_given? })),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling recover(#{args[0]})"
      end
    end
    #  The HTTP method for the request.
    # @overload method()
    # @return [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER]
    def method
      if !block_given?
        return @j_del.java_method(:method, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling method()"
      end
    end
    # @overload query()
    # @return [String] the query part of the uri. For example someparam=32&amp;someotherparam=x
    def query
      if !block_given?
        return @j_del.java_method(:query, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query()"
      end
    end
    #  If chunked is true then the request will be set into HTTP chunked mode
    # @overload setChunked(chunked)
    #   @param [true,false] chunked true if chunked encoding
    # @return [self]
    def set_chunked(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setChunked, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_chunked(#{args[0]})"
      end
    end
    # @overload uri()
    # @return [String] The URI of the request.
    def uri
      if !block_given?
        return @j_del.java_method(:uri, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling uri()"
      end
    end
    #  Map the failure of a future to <code>null</code>.<p>
    # 
    #  This is a convenience for <code>future.otherwise((T) null)</code>.<p>
    # 
    #  When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
    # 
    #  When this future succeeds, the result will be propagated to the returned future.
    # @overload otherwiseEmpty()
    # @return [::Vertx::Future] the mapped future
    def otherwise_empty
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwiseEmpty, []).call(),::Vertx::Future,::Vertx::HttpClientResponse.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling otherwise_empty()"
      end
    end
    #  If you send an HTTP request with the header <code>Expect</code> set to the value <code>100-continue</code>
    #  and the server responds with an interim HTTP response with a status code of <code>100</code> and a continue handler
    #  has been set using this method, then the <code>handler</code> will be called.
    #  <p>
    #  You can then continue to write data to the request body and later end it. This is normally used in conjunction with
    #  the {::Vertx::HttpClientRequest#send_head} method to force the request header to be written before the request has ended.
    # @overload continueHandler(handler)
    #   @yield 
    # @return [self]
    def continue_handler
      if true
        @j_del.java_method(:continueHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling continue_handler()"
      end
    end
    # @overload getStreamPriority()
    # @return [Hash{String => Object}] the priority of the associated HTTP/2 stream for HTTP/2 otherwise <code>null</code>
    def get_stream_priority
      if !block_given?
        return @j_del.java_method(:getStreamPriority, []).call() != nil ? JSON.parse(@j_del.java_method(:getStreamPriority, []).call().toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_stream_priority()"
      end
    end
    #  Set's the amount of time after which if the request does not return any data within the timeout period an
    #  TimeoutException will be passed to the exception handler (if provided) and
    #  the request will be closed.
    #  <p>
    #  Calling this method more than once has the effect of canceling any existing timeout and starting
    #  the timeout from scratch.
    # @overload setTimeout(timeoutMs)
    #   @param [Fixnum] timeoutMs The quantity of time in milliseconds.
    # @return [self]
    def set_timeout(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setTimeout, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_timeout(#{args[0]})"
      end
    end
    #  Compose this future with a <code>mapper</code> function.<p>
    # 
    #  When this future (the one on which <code>compose</code> is called) succeeds, the <code>mapper</code> will be called with
    #  the completed value and this mapper returns another future object. This returned future completion will complete
    #  the future returned by this method call.<p>
    # 
    #  If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
    #  will not be called.
    # @overload compose(mapper)
    #   @yield the mapper function
    # @return [::Vertx::Future] the composed future
    def compose(*args)
      if block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:compose, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)).j_del unless !block_given? })),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling compose(#{args[0]})"
      end
    end
    #  Sets the priority of the associated stream.
    #  <p/>
    #  This is not implemented for HTTP/1.x.
    # @overload setStreamPriority(streamPriority)
    #   @param [Hash{String => Object}] streamPriority the priority of this request's stream
    # @return [self]
    def set_stream_priority(*args)
      if args[0].class == Hash && !block_given?
        @j_del.java_method(:setStreamPriority, [Java::IoVertxCoreHttp::StreamPriority.java_class]).call(Java::IoVertxCoreHttp::StreamPriority.new(::Vertx::Util::Utils.to_json_object(args[0])))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_stream_priority(#{args[0]})"
      end
    end
    #  Reset this request:
    #  <p/>
    #  <ul>
    #    <li>for HTTP/2, this performs send an HTTP/2 reset frame with the specified error <code>code</code></li>
    #    <li>for HTTP/1.x, this closes the connection when the current request is inflight</li>
    #  </ul>
    #  <p/>
    #  When the request has not yet been sent, the request will be aborted and false is returned as indicator.
    #  <p/>
    # @overload reset()
    # @overload reset(code)
    #   @param [Fixnum] code the error code
    # @return [true,false] true when reset has been performed
    def reset?(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:reset, []).call()
      elsif args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:reset, [Java::long.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reset?(#{args[0]})"
      end
    end
    #  Put an HTTP header
    # @overload putHeader(name,value)
    #   @param [String] name The header name
    #   @param [String] value The header value
    # @return [self]
    def put_header(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:putHeader, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_header(#{args[0]},#{args[1]})"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
  end
end
