require 'vertx/multi_map'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.eventbus.Message
module Vertx
  #  Represents a message that is received from the event bus in a handler.
  #  <p>
  #  Messages have a {::Vertx::Message#body}, which can be null, and also {::Vertx::Message#headers}, which can be empty.
  #  <p>
  #  If the message was sent specifying a reply handler, it can be replied to using {::Vertx::Message#reply}.
  #  <p>
  #  If you want to notify the sender that processing failed, then {::Vertx::Message#fail} can be called.
  class Message
    # @private
    # @param j_del [::Vertx::Message] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::Message] the underlying java delegate
    def j_del
      @j_del
    end
    #  Signal to the sender that processing of this message failed.
    #  <p>
    #  If the message was sent specifying a result handler
    #  the handler will be called with a failure corresponding to the failure code and message specified here.
    # @overload fail(failureCode,message)
    #   @param [Fixnum] failureCode A failure code to pass back to the sender
    #   @param [String] message A message to pass back to the sender
    # @return [void]
    def fail(*args)
      if args[0].class == Fixnum && args[1].class == String && !block_given?
        return @j_del.java_method(:fail, [Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fail(#{args[0]},#{args[1]})"
      end
    end
    #  Multi-map of message headers. Can be empty
    # @overload headers()
    # @return [::Vertx::MultiMap] the headers
    def headers
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headers, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling headers()"
      end
    end
    #  The address the message was sent to
    # @overload address()
    # @return [String]
    def address
      if !block_given?
        return @j_del.java_method(:address, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling address()"
      end
    end
    #  Signals if this message represents a send or publish event.
    # @overload isSend()
    # @return [true,false] true if this is a send.
    def send?
      if !block_given?
        return @j_del.java_method(:isSend, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send?()"
      end
    end
    #  Link {::Vertx::Message#reply} but allows you to specify delivery options for the reply.
    # @overload reply(message)
    #   @param [Object] message the message to reply with.
    # @overload reply(message,options)
    #   @param [Object] message the reply message
    #   @param [Hash{String => Object}] options the delivery options
    # @return [void]
    def reply(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given? && args[1] == nil
        return @j_del.java_method(:reply, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == Hash && !block_given?
        return @j_del.java_method(:reply, [Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reply(#{args[0]},#{args[1]})"
      end
    end
    #  The body of the message. Can be null.
    # @overload body()
    # @return [Object] the body, or null.
    def body
      if !block_given?
        if @cached_body != nil
          return @cached_body
        end
        return @cached_body = @j_arg_T.wrap(@j_del.java_method(:body, []).call())
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling body()"
      end
    end
    #  The reply address. Can be null.
    # @overload replyAddress()
    # @return [String] the reply address, or null, if message was sent without a reply handler.
    def reply_address
      if !block_given?
        return @j_del.java_method(:replyAddress, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reply_address()"
      end
    end
    #  Like {::Vertx::Message#reply_and_request} but specifying <code>options</code> that can be used
    #  to configure the delivery.
    # @overload replyAndRequest(message,replyHandler)
    #   @param [Object] message the message to reply with.
    #   @yield the reply handler for the reply.
    # @overload replyAndRequest(message,options,replyHandler)
    #   @param [Object] message the message body, may be <code>null</code>
    #   @param [Hash{String => Object}] options delivery options
    #   @yield reply handler will be called when any reply from the recipient is received
    # @return [void]
    def reply_and_request(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:replyAndRequest, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:replyAndRequest, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Message.j_api_type)
        end
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == Hash && true
        if (block_given?)
          return @j_del.java_method(:replyAndRequest, [Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:replyAndRequest, [Java::java.lang.Object.java_class,Java::IoVertxCoreEventbus::DeliveryOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),Java::IoVertxCoreEventbus::DeliveryOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Message, nil) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Message.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reply_and_request(#{args[0]},#{args[1]})"
      end
    end
  end
end
