require 'vertx/write_stream'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.streams.Pipe
module Vertx
  #  Pipe data from a {::Vertx::ReadStream} to a {::Vertx::WriteStream} and performs flow control where necessary to
  #  prevent the write stream buffer from getting overfull.
  #  <p>
  #  Instances of this class read items from a {::Vertx::ReadStream} and write them to a {::Vertx::WriteStream}. If data
  #  can be read faster than it can be written this could result in the write queue of the {::Vertx::WriteStream} growing
  #  without bound, eventually causing it to exhaust all available RAM.
  #  <p>
  #  To prevent this, after each write, instances of this class check whether the write queue of the {::Vertx::WriteStream} is full, and if so, the {::Vertx::ReadStream} is paused, and a <code>drainHandler</code> is set on the
  #  {::Vertx::WriteStream}.
  #  <p>
  #  When the {::Vertx::WriteStream} has processed half of its backlog, the <code>drainHandler</code> will be
  #  called, which results in the pump resuming the {::Vertx::ReadStream}.
  #  <p>
  #  This class can be used to pipe from any {::Vertx::ReadStream} to any {::Vertx::WriteStream},
  #  e.g. from an {::Vertx::HttpServerRequest} to an {::Vertx::AsyncFile},
  #  or from {::Vertx::NetSocket} to a {::Vertx::WebSocket}.
  #  <p>
  #  Please see the documentation for more information.
  class Pipe
    # @private
    # @param j_del [::Vertx::Pipe] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::Pipe] the underlying java delegate
    def j_del
      @j_del
    end
    #  Set to <code>true</code> to call {::Vertx::WriteStream#end} when the source <code>ReadStream</code> succeeds, <code>false</code> otherwise.
    # @overload endOnSuccess(end)
    #   @param [true,false] _end <code>true</code> to end the stream on a source <code>ReadStream</code> success
    # @return [self]
    def end_on_success(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:endOnSuccess, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_on_success(#{args[0]})"
      end
    end
    #  Start to pipe the elements to the destination <code>WriteStream</code>.
    #  <p>
    #  When the operation fails with a write error, the source stream is resumed.
    # @overload to(dst,completionHandler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield the handler called when the pipe operation completes
    # @return [void]
    def to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:to, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:to, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling to(#{args[0]})"
      end
    end
    #  Close the pipe.
    #  <p>
    #  The streams handlers will be unset and the read stream resumed unless it is already ended.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Set to <code>true</code> to call {::Vertx::WriteStream#end} when the source <code>ReadStream</code> completes, <code>false</code> otherwise.
    #  <p>
    #  Calling this overwrites {::Vertx::Pipe#end_on_failure} and {::Vertx::Pipe#end_on_success}.
    # @overload endOnComplete(end)
    #   @param [true,false] _end <code>true</code> to end the stream on a source <code>ReadStream</code> completion
    # @return [self]
    def end_on_complete(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:endOnComplete, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_on_complete(#{args[0]})"
      end
    end
    #  Set to <code>true</code> to call {::Vertx::WriteStream#end} when the source <code>ReadStream</code> fails, <code>false</code> otherwise.
    # @overload endOnFailure(end)
    #   @param [true,false] _end <code>true</code> to end the stream on a source <code>ReadStream</code> failure
    # @return [self]
    def end_on_failure(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:endOnFailure, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_on_failure(#{args[0]})"
      end
    end
  end
end
