require 'vertx-auth-common/authorization'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.authorization.AndAuthorization
module VertxAuthCommon
  #  Allows to perform a logical 'and' between several authorizations
  class AndAuthorization < ::VertxAuthCommon::Authorization
    # @private
    # @param j_del [::VertxAuthCommon::AndAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::AndAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AndAuthorization
    end
    def @@j_api_type.wrap(obj)
      AndAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthAuthorization::AndAuthorization.java_class
    end
    # @overload getAuthorizations()
    # @return [Array<::VertxAuthCommon::Authorization>]
    def get_authorizations
      if !block_given?
        return @j_del.java_method(:getAuthorizations, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxAuthCommon::Authorization) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_authorizations()"
      end
    end
    # @overload create()
    # @return [::VertxAuthCommon::AndAuthorization]
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthAuthorization::AndAuthorization.java_method(:create, []).call(),::VertxAuthCommon::AndAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
    # @overload addAuthorization(authorization)
    #   @param [::VertxAuthCommon::Authorization] authorization 
    # @return [::VertxAuthCommon::AndAuthorization]
    def add_authorization(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:addAuthorization, [Java::IoVertxExtAuthAuthorization::Authorization.java_class]).call(args[0].j_del),::VertxAuthCommon::AndAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_authorization(#{args[0]})"
      end
    end
  end
end
