require 'vertx-auth-common/user'
require 'vertx-auth-common/authorization'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.authorization.AuthorizationProvider
module VertxAuthCommon
  #  The role of an AuthorizationProvider is to return a set of Authorization.
  #  Note that each AuthorizationProvider must provide its own unique Id
  class AuthorizationProvider
    # @private
    # @param j_del [::VertxAuthCommon::AuthorizationProvider] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::AuthorizationProvider] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AuthorizationProvider
    end
    def @@j_api_type.wrap(obj)
      AuthorizationProvider.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthAuthorization::AuthorizationProvider.java_class
    end
    #  Returns the set of authorizations of the specified user
    # @overload getAuthorizations(user,handler)
    #   @param [::VertxAuthCommon::User] user 
    #   @yield 
    # @return [void]
    def get_authorizations(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:getAuthorizations, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxAuthCommon::Authorization) } : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:getAuthorizations, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxAuthCommon::Authorization) } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_authorizations(#{args[0]})"
      end
    end
    #  create an authorization provider with the specified id and authorizations
    # @overload create(id,authorizations)
    #   @param [String] id 
    #   @param [Set<::VertxAuthCommon::Authorization>] authorizations 
    # @return [::VertxAuthCommon::AuthorizationProvider] 
    def self.create(*args)
      if args[0].class == String && args[1].class == Set && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthAuthorization::AuthorizationProvider.java_method(:create, [Java::java.lang.String.java_class,Java::JavaUtil::Set.java_class]).call(args[0],Java::JavaUtil::LinkedHashSet.new(args[1].map { |element| element.j_del })),::VertxAuthCommon::AuthorizationProvider)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  returns the id of the authorization provider
    # @overload getId()
    # @return [String] 
    def get_id
      if !block_given?
        return @j_del.java_method(:getId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_id()"
      end
    end
  end
end
