require 'vertx-auth-common/authorizations'
require 'vertx/future'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.User
module VertxAuthCommon
  #  Represents an authenticates User and contains operations to authorise the user.
  #  <p>
  #  Please consult the documentation for a detailed explanation.
  class User
    # @private
    # @param j_del [::VertxAuthCommon::User] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::User] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == User
    end
    def @@j_api_type.wrap(obj)
      User.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuth::User.java_class
    end
    #  Get the underlying principal for the User. What this actually returns depends on the implementation.
    #  For a simple user/password based auth, it's likely to contain a JSON object with the following structure:
    #  <pre>
    #    {
    #      "username", "tim"
    #    }
    #  </pre>
    # @overload principal()
    # @return [Hash{String => Object}] JSON representation of the Principal
    def principal
      if !block_given?
        return @j_del.java_method(:principal, []).call() != nil ? JSON.parse(@j_del.java_method(:principal, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling principal()"
      end
    end
    #  Is the user authorised to
    # @overload isAuthorized(authority,resultHandler)
    #   @param [String] authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
    #   @yield handler that will be called with an {AsyncResult} containing the value `true` if the they has the authority or `false` otherwise.
    # @return [self]
    def is_authorized(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:isAuthorized, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:isAuthorized, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling is_authorized(#{args[0]})"
      end
    end
    #  Flags this user object to be expired. Expiration takes 3 values in account:
    # 
    #  <ol>
    #    <li><code>exp</code> "expiration" timestamp in seconds.</li>
    #    <li><code>iat</code> "issued at" in seconds.</li>
    #    <li><code>nbf</code> "not before" in seconds.</li>
    #  </ol>
    #  A User is considered expired if it contains any of the above and
    #  the current clock time does not agree with the parameter value. If the {::VertxAuthCommon::User#principal} do not contain a key
    #  then {::VertxAuthCommon::User#attributes} are checked.
    #  <p>
    #  If all of the properties are not available the user will not expire.
    #  <p>
    #  Implementations of this interface might relax this rule to account for a leeway to safeguard against
    #  clock drifting.
    # @overload expired()
    # @overload expired(leeway)
    #   @param [Fixnum] leeway a greater than zero leeway value.
    # @return [true,false] <code>true</code> if expired
    def expired?(*args)
      if !block_given? && args[0] == nil
        return @j_del.java_method(:expired, []).call()
      elsif args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:expired, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling expired?(#{args[0]})"
      end
    end
    #  Set the auth provider for the User. This is typically used to reattach a detached User with an AuthProvider, e.g.
    #  after it has been deserialized.
    # @overload setAuthProvider(authProvider)
    #   @param [::VertxAuthCommon::AuthProvider] authProvider the AuthProvider - this must be the same type of AuthProvider that originally created the User
    # @return [void]
    def set_auth_provider(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:setAuthProvider, [Java::IoVertxExtAuth::AuthProvider.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_auth_provider(#{args[0]})"
      end
    end
    #  returns user's authorizations
    # @overload authorizations()
    # @return [::VertxAuthCommon::Authorizations] 
    def authorizations
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:authorizations, []).call(),::VertxAuthCommon::Authorizations)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling authorizations()"
      end
    end
    # @overload create(principal)
    #   @param [Hash{String => Object}] principal 
    # @overload create(principal,attributes)
    #   @param [Hash{String => Object}] principal 
    #   @param [Hash{String => Object}] attributes 
    # @return [::VertxAuthCommon::User]
    def self.create(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuth::User.java_method(:create, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0])),::VertxAuthCommon::User)
      elsif args[0].class == Hash && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuth::User.java_method(:create, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]),::Vertx::Util::Utils.to_json_object(args[1])),::VertxAuthCommon::User)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Gets extra attributes of the user. Attributes contains any attributes related
    #  to the outcome of authenticating a user (e.g.: issued date, metadata, etc...)
    # @overload attributes()
    # @return [Hash{String => Object}] a json object with any relevant attribute.
    def attributes
      if !block_given?
        return @j_del.java_method(:attributes, []).call() != nil ? JSON.parse(@j_del.java_method(:attributes, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling attributes()"
      end
    end
    #  The User object will cache any authorities that it knows it has to avoid hitting the
    #  underlying auth provider each time.  Use this method if you want to clear this cache.
    # @overload clearCache()
    # @return [self]
    def clear_cache
      if !block_given?
        @j_del.java_method(:clearCache, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clear_cache()"
      end
    end
  end
end
