require 'vertx/vertx'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.jwt.JWTAuth
module VertxAuthJwt
  #  Factory interface for creating JWT based {::VertxAuthCommon::AuthProvider} instances.
  class JWTAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthJwt::JWTAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthJwt::JWTAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JWTAuth
    end
    def @@j_api_type.wrap(obj)
      JWTAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthJwt::JWTAuth.java_class
    end
    #  Generate a new JWT token.
    # @overload generateToken(claims)
    #   @param [Hash{String => Object}] claims Json with user defined claims for a list of official claims
    # @overload generateToken(claims,options)
    #   @param [Hash{String => Object}] claims Json with user defined claims for a list of official claims
    #   @param [Hash{String => Object}] options extra options for the generation
    # @return [String] JWT encoded token
    def generate_token(*args)
      if args[0].class == Hash && !block_given? && args[1] == nil
        return @j_del.java_method(:generateToken, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      elsif args[0].class == Hash && args[1].class == Hash && !block_given?
        return @j_del.java_method(:generateToken, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtJwt::JWTOptions.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]),Java::IoVertxExtJwt::JWTOptions.new(::Vertx::Util::Utils.to_json_object(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling generate_token(#{args[0]},#{args[1]})"
      end
    end
    #  Create a JWT auth provider
    # @overload create(vertx,config)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    #   @param [Hash{String => Object}] config the config
    # @return [::VertxAuthJwt::JWTAuth] the auth provider
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJwt::JWTAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthJwt::JWTAuthOptions.java_class]).call(args[0].j_del,Java::IoVertxExtAuthJwt::JWTAuthOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxAuthJwt::JWTAuth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
  end
end
