require 'vertx-auth-common/authorization_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization
module VertxAuthJwt
  #  Implementation of the Microprofile MP-JWT 1.1 RBAC based on the access token groups key.
  class MicroProfileAuthorization < ::VertxAuthCommon::AuthorizationProvider
    # @private
    # @param j_del [::VertxAuthJwt::MicroProfileAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthJwt::MicroProfileAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MicroProfileAuthorization
    end
    def @@j_api_type.wrap(obj)
      MicroProfileAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthJwtAuthorization::MicroProfileAuthorization.java_class
    end
    #  Factory method to create a Authorization provider for tokens adhering to the MP-JWT 1.1 spec.
    #  When the user is known to not be a JWT, (e.g.: a OAuth2 response token) then the root claim
    #  is expected to be extracted from  under the key <code>accessToken</code>.
    # @overload create()
    # @return [::VertxAuthJwt::MicroProfileAuthorization] a AuthorizationProvider
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJwtAuthorization::MicroProfileAuthorization.java_method(:create, []).call(),::VertxAuthJwt::MicroProfileAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
  end
end
