require 'vertx-auth-common/authorization_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization
module VertxAuthOauth2
  #  Scope is a mechanism in OAuth 2.0 to limit an application's access to a user's account.
  #  An application can request one or more scopes, this information is then presented to the
  #  user in the consent screen, and the access token issued to the application will be
  #  limited to the scopes granted.
  # 
  #  The OAuth spec allows the authorization server or user to modify the scopes granted to
  #  the application compared to what is requested, although there are not many examples of
  #  services doing this in practice.
  # 
  #  OAuth2 does not define any particular values for scopes, since it is highly dependent
  #  on the service's internal architecture and needs.
  class ScopeAuthorization < ::VertxAuthCommon::AuthorizationProvider
    # @private
    # @param j_del [::VertxAuthOauth2::ScopeAuthorization] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::ScopeAuthorization] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ScopeAuthorization
    end
    def @@j_api_type.wrap(obj)
      ScopeAuthorization.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2Authorization::ScopeAuthorization.java_class
    end
    #  Returns a String with the given scopes concatenated with the given separator.
    # @overload encode(scopes)
    #   @param [Array<String>] scopes a list of scopes
    # @return [String] concatenated string.
    def encode(*args)
      if args[0].class == Array && !block_given?
        return @j_del.java_method(:encode, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element })
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling encode(#{args[0]})"
      end
    end
    #  Factory method to create a Authorization provider for Oauth 2.0 scopes.
    # @overload create(scopeSeparator)
    #   @param [String] scopeSeparator the scope separator e.g.: <code>" "</code>, <code>","</code>, <code>"+"</code>
    # @return [::VertxAuthOauth2::ScopeAuthorization] a AuthorizationProvider
    def self.create(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Authorization::ScopeAuthorization.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxAuthOauth2::ScopeAuthorization)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Returns the configured separator.
    # @overload separator()
    # @return [String] the separator.
    def separator
      if !block_given?
        return @j_del.java_method(:separator, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling separator()"
      end
    end
  end
end
