require 'vertx/promise'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.bridge.BaseBridgeEvent
module VertxBridgeCommon
  #  Represents an event that occurs on the event bus bridge.
  #  <p>
  #  Please consult the documentation for a full explanation.
  class BaseBridgeEvent < ::Vertx::Promise
    # @private
    # @param j_del [::VertxBridgeCommon::BaseBridgeEvent] the java delegate
    def initialize(j_del)
      super(j_del, nil)
      @j_del = j_del
    end
    # @private
    # @return [::VertxBridgeCommon::BaseBridgeEvent] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == BaseBridgeEvent
    end
    def @@j_api_type.wrap(obj)
      BaseBridgeEvent.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtBridge::BaseBridgeEvent.java_class
    end
    # @overload future()
    # @return [::Vertx::Future] the  associated with this promise, it can be used to be aware of the promise completion
    def future
      if !block_given?
        if @cached_future != nil
          return @cached_future
        end
        return @cached_future = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:future, []).call(),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling future()"
      end
    end
    #  Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
    #  no message involved.
    # @overload setRawMessage(message)
    #   @param [Hash{String => Object}] message the raw message
    # @return [self]
    def set_raw_message(*args)
      if args[0].class == Hash && !block_given?
        @j_del.java_method(:setRawMessage, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_raw_message(#{args[0]})"
      end
    end
    #  Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
    #  no message involved. If the returned message is modified, {::VertxBridgeCommon::BaseBridgeEvent#set_raw_message} should be called with the
    #  new message.
    # @overload getRawMessage()
    # @return [Hash{String => Object}] the raw JSON message for the event
    def get_raw_message
      if !block_given?
        return @j_del.java_method(:getRawMessage, []).call() != nil ? JSON.parse(@j_del.java_method(:getRawMessage, []).call().encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_raw_message()"
      end
    end
    #  Like {::Vertx::Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
    #  an IllegalStateException, it returns <code>true</code> otherwise.
    # @overload tryComplete(result)
    #   @param [true,false] result the result
    # @return [true,false] <code>false</code> when the future is already completed
    def try_complete?(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return @j_del.java_method(:tryComplete, [Java::JavaLang::Boolean.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling try_complete?(#{args[0]})"
      end
    end
    # @overload type()
    # @return [:SOCKET_CREATED,:SOCKET_CLOSED,:SOCKET_IDLE,:SOCKET_PING,:SEND,:PUBLISH,:RECEIVE,:REGISTER,:REGISTERED,:UNREGISTER] the type of the event
    def type
      if !block_given?
        if @cached_type != nil
          return @cached_type
        end
        return @cached_type = @j_del.java_method(:type, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling type()"
      end
    end
    #  Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
    #  <p/>
    #  Any handler set on the associated promise will be called.
    # @overload complete(result)
    #   @param [true,false] result the result
    # @return [void]
    def complete(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        return @j_del.java_method(:complete, [Java::JavaLang::Boolean.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling complete(#{args[0]})"
      end
    end
  end
end
