require 'vertx/vertx'
require 'vertx-consul/watch_result'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.consul.Watch
module VertxConsul
  #  Watches are a way of specifying a view of data (e.g. list of nodes, KV pairs, health checks)
  #  which is monitored for updates. When an update is detected, an <code>Handler</code> with <code>AsyncResult</code> is invoked.
  #  As an example, you could watch the status of health checks and notify when a check is critical.
  class Watch
    # @private
    # @param j_del [::VertxConsul::Watch] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxConsul::Watch] the underlying java delegate
    def j_del
      @j_del
    end
    #  Set the result handler. As data is changed, the handler will be called with the result.
    # @overload setHandler(handler)
    #   @yield the result handler
    # @return [self]
    def set_handler
      if true
        @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxConsul::WatchResult, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_handler()"
      end
    end
    #  Creates <code>Watch</code> to monitoring the list of available nodes.
    #  This maps to the <a href="https://www.consul.io/api/catalog.html#list-nodes">/v1/catalog/nodes</a> API internally.
    # @overload nodes(vertx)
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @overload nodes(vertx,options)
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    #   @param [Hash{String => Object}] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.nodes(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:nodes, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::NodeList))
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:nodes, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(args[0].j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::NodeList))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling nodes(#{args[0]},#{args[1]})"
      end
    end
    #  Stop the watch and release its resources
    # @overload stop()
    # @return [void]
    def stop
      if !block_given?
        return @j_del.java_method(:stop, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stop()"
      end
    end
    #  Creates <code>Watch</code> to monitoring the nodes providing the service.
    #  This maps to the <a href="https://www.consul.io/docs/agent/http/health.html#health_service">/v1/health/service/&lt;service&gt;</a> API internally.
    # @overload service(service,vertx)
    #   @param [String] service the service name
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @overload service(service,vertx,options)
    #   @param [String] service the service name
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    #   @param [Hash{String => Object}] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.service(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:service, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(args[0],args[1].j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceEntryList))
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:service, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(args[0],args[1].j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceEntryList))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling service(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Start this <code>Watch</code>
    # @overload start()
    # @return [self]
    def start
      if !block_given?
        @j_del.java_method(:start, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling start()"
      end
    end
    #  Creates <code>Watch</code> to monitoring the list of available services.
    #  This maps to the <a href="https://www.consul.io/docs/agent/http/catalog.html#catalog_services">/v1/catalog/services</a> API internally.
    # @overload services(vertx)
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @overload services(vertx,options)
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    #   @param [Hash{String => Object}] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.services(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:services, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:services, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(args[0].j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::ServiceList))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling services(#{args[0]},#{args[1]})"
      end
    end
    #  Creates <code>Watch</code> to monitoring a prefix of keys in the KV store.
    #  This maps to the <a href="https://www.consul.io/api/kv.html">/v1/kv/</a> API internally.
    # @overload keyPrefix(keyPrefix,vertx)
    #   @param [String] keyPrefix the key
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @overload keyPrefix(keyPrefix,vertx,options)
    #   @param [String] keyPrefix the key
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    #   @param [Hash{String => Object}] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.key_prefix(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:keyPrefix, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(args[0],args[1].j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValueList))
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:keyPrefix, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(args[0],args[1].j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValueList))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling key_prefix(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Creates <code>Watch</code> to monitoring the custom user events.
    #  This maps to the <a href="https://www.consul.io/docs/agent/http/event.html#event_list">/v1/event/list</a> API internally.
    # @overload events(event,vertx)
    #   @param [String] event the event name
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @overload events(event,vertx,options)
    #   @param [String] event the event name
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    #   @param [Hash{String => Object}] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.events(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:events, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(args[0],args[1].j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::EventList))
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:events, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(args[0],args[1].j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::EventList))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling events(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Creates <code>Watch</code> to monitoring a specific key in the KV store.
    #  This maps to the <a href="https://www.consul.io/api/kv.html">/v1/kv/</a> API internally.
    # @overload key(key,vertx)
    #   @param [String] key the key
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    # @overload key(key,vertx,options)
    #   @param [String] key the key
    #   @param [::Vertx::Vertx] vertx the <code>Vertx</code> instance
    #   @param [Hash{String => Object}] options the options to create underlying Consul client
    # @return [::VertxConsul::Watch] the <code>Watch</code> instance
    def self.key(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:key, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(args[0],args[1].j_del),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValue))
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtConsul::Watch.java_method(:key, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtConsul::ConsulClientOptions.java_class]).call(args[0],args[1].j_del,Java::IoVertxExtConsul::ConsulClientOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxConsul::Watch,::Vertx::Util::data_object_type(Java::IoVertxExtConsul::KeyValue))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling key(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
  end
end
