require 'vertx-mqtt/mqtt_conn_ack_message'
require 'vertx/buffer'
require 'vertx/vertx'
require 'vertx-mqtt/mqtt_publish_message'
require 'vertx/future'
require 'vertx-mqtt/mqtt_sub_ack_message'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.mqtt.MqttClient
module VertxMqtt
  #  An MQTT client
  class MqttClient
    # @private
    # @param j_del [::VertxMqtt::MqttClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMqtt::MqttClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MqttClient
    end
    def @@j_api_type.wrap(obj)
      MqttClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMqtt::MqttClient.java_class
    end
    #  Disconnects from the MQTT server calling disconnectHandler after disconnection
    # @overload disconnect(disconnectHandler)
    #   @yield handler called when asynchronous disconnect call ends
    # @return [self]
    def disconnect
      if true
        if (block_given?)
          @j_del.java_method(:disconnect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:disconnect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling disconnect()"
      end
    end
    # @overload clientId()
    # @return [String] the client identifier
    def client_id
      if !block_given?
        return @j_del.java_method(:clientId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling client_id()"
      end
    end
    #  Subscribes to the topic with a specified QoS level
    # @overload subscribe(topics,subscribeSentHandler)
    #   @param [Hash{String => Fixnum}] topics topics you subscribe on
    #   @yield handler called after SUBSCRIBE packet sent with packetid
    # @overload subscribe(topic,qos,subscribeSentHandler)
    #   @param [String] topic topic you subscribe on
    #   @param [Fixnum] qos QoS level
    #   @yield handler called after SUBSCRIBE packet sent with packetid
    # @return [self]
    def subscribe(*args)
      if args[0].class == Hash && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:subscribe, [Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(Hash[args[0].map { |k,v| [k,::Vertx::Util::Utils.to_integer(v)] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:subscribe, [Java::JavaUtil::Map.java_class,Java::IoVertxCore::Handler.java_class]).call(Hash[args[0].map { |k,v| [k,::Vertx::Util::Utils.to_integer(v)] }],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == String && args[1].class == Fixnum && true
        if (block_given?)
          @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscribe(#{args[0]},#{args[1]})"
      end
    end
    #  This method is needed by the client in order to avoid server closes the
    #  connection due to the keep alive timeout if client has no messages to send
    # @overload ping()
    # @return [self]
    def ping
      if !block_given?
        @j_del.java_method(:ping, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ping()"
      end
    end
    #  Sets handler which will be called each time publish is completed
    # @overload publishCompletionHandler(publishCompletionHandler)
    #   @yield handler called with the packetId
    # @return [self]
    def publish_completion_handler
      if true
        @j_del.java_method(:publishCompletionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_completion_handler()"
      end
    end
    # @overload isConnected()
    # @return [true,false] if the connection between client and remote server is established/open
    def connected?
      if !block_given?
        return @j_del.java_method(:isConnected, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connected?()"
      end
    end
    #  Set a handler that will be called when the connection with server is closed
    # @overload closeHandler(closeHandler)
    #   @yield handler to call
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    #  Sets handler which will be called after PINGRESP packet receiving
    # @overload pingResponseHandler(pingResponseHandler)
    #   @yield handler to call
    # @return [self]
    def ping_response_handler
      if true
        @j_del.java_method(:pingResponseHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ping_response_handler()"
      end
    end
    #  Sets handler which will be called after SUBACK packet receiving
    # @overload subscribeCompletionHandler(subscribeCompletionHandler)
    #   @yield handler to call. List inside is a granted QoS array
    # @return [self]
    def subscribe_completion_handler
      if true
        @j_del.java_method(:subscribeCompletionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxMqtt::MqttSubAckMessage)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscribe_completion_handler()"
      end
    end
    #  Unsubscribe from receiving messages on given topic
    # @overload unsubscribe(topic,unsubscribeSentHandler)
    #   @param [String] topic Topic you want to unsubscribe from
    #   @yield handler called after UNSUBSCRIBE packet sent
    # @return [self]
    def unsubscribe(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:unsubscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unsubscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unsubscribe(#{args[0]})"
      end
    end
    #  Sends the PUBLISH message to the remote MQTT server
    # @overload publish(topic,payload,qosLevel,isDup,isRetain,publishSentHandler)
    #   @param [String] topic topic on which the message is published
    #   @param [::Vertx::Buffer] payload message payload
    #   @param [:AT_MOST_ONCE,:AT_LEAST_ONCE,:EXACTLY_ONCE,:FAILURE] qosLevel QoS level
    #   @param [true,false] isDup if the message is a duplicate
    #   @param [true,false] isRetain if the message needs to be retained
    #   @yield handler called after PUBLISH packet sent with packetid (not when QoS 0)
    # @return [self]
    def publish(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Symbol && (args[3].class == TrueClass || args[3].class == FalseClass) && (args[4].class == TrueClass || args[4].class == FalseClass) && true
        if (block_given?)
          @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoNettyHandlerCodecMqtt::MqttQoS.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(args[2].to_s),args[3],args[4],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:publish, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoNettyHandlerCodecMqtt::MqttQoS.java_class,Java::boolean.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,Java::IoNettyHandlerCodecMqtt::MqttQoS.valueOf(args[2].to_s),args[3],args[4],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Sets handler which will be called each time server publish something to client
    # @overload publishHandler(publishHandler)
    #   @yield handler to call
    # @return [self]
    def publish_handler
      if true
        @j_del.java_method(:publishHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxMqtt::MqttPublishMessage)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling publish_handler()"
      end
    end
    #  Return an MQTT client instance
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx Vert.x instance
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx Vert.x instance
    #   @param [Hash{String => Object}] options MQTT client options
    # @return [::VertxMqtt::MqttClient] MQTT client instance
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxMqtt::MqttClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxMqtt::MqttClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxMqtt::MqttClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxMqtt::MqttClientOptions.java_class]).call(args[0].j_del,Java::IoVertxMqtt::MqttClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxMqtt::MqttClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Sets handler which will be called after UNSUBACK packet receiving
    # @overload unsubscribeCompletionHandler(unsubscribeCompletionHandler)
    #   @yield handler to call with the packetid
    # @return [self]
    def unsubscribe_completion_handler
      if true
        @j_del.java_method(:unsubscribeCompletionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unsubscribe_completion_handler()"
      end
    end
    #  Set an exception handler for the client, that will be called when an error happens
    #  in internal netty structures.
    # 
    #  <code>io.netty.handler.codec.DecoderException</code> can be one of the cause
    # @overload exceptionHandler(handler)
    #   @yield the exception handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Connects to an MQTT server calling connectHandler after connection
    # @overload connect(port,host,connectHandler)
    #   @param [Fixnum] port port of the MQTT server
    #   @param [String] host hostname/ip address of the MQTT server
    #   @yield handler called when the asynchronous connect call ends
    # @overload connect(port,host,serverName,connectHandler)
    #   @param [Fixnum] port port of the MQTT server
    #   @param [String] host hostname/ip address of the MQTT server
    #   @param [String] serverName the SNI server name
    #   @yield handler called when the asynchronous connect call ends
    # @return [self]
    def connect(*args)
      if args[0].class == Fixnum && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttConnAckMessage) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttConnAckMessage) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMqtt::MqttConnAckMessage.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class == String && true
        if (block_given?)
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttConnAckMessage) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMqtt::MqttConnAckMessage) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMqtt::MqttConnAckMessage.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
  end
end
