require 'vertx/vertx'
require 'vertx-sql-client/row'
require 'vertx-sql-client/pool'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/tuple'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.pgclient.PgPool
module VertxPgClient
  #  A pool of PostgreSQL connections.
  class PgPool < ::VertxSqlClient::Pool
    # @private
    # @param j_del [::VertxPgClient::PgPool] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxPgClient::PgPool] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgPool
    end
    def @@j_api_type.wrap(obj)
      PgPool.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxPgclient::PgPool.java_class
    end
    # @overload preparedBatch(sql,batch,handler)
    #   @param [String] sql 
    #   @param [Array<::VertxSqlClient::Tuple>] batch 
    #   @yield 
    # @return [self]
    def prepared_batch(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepared_batch(#{args[0]},#{args[1]})"
      end
    end
    # @overload query(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @return [self]
    def query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query(#{args[0]})"
      end
    end
    #  Like {::VertxPgClient::PgPool#pool} with a specific  instance.
    # @overload pool()
    # @overload pool(poolOptions)
    #   @param [Hash{String => Object}] poolOptions 
    # @overload pool(connectionUri)
    #   @param [String] connectionUri 
    # @overload pool(connectionUri,poolOptions)
    #   @param [String] connectionUri 
    #   @param [Hash{String => Object}] poolOptions 
    # @overload pool(vertx,connectionUri)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    # @overload pool(vertx,poolOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] poolOptions 
    # @overload pool(connectOptions,poolOptions)
    #   @param [Hash{String => Object}] connectOptions 
    #   @param [Hash{String => Object}] poolOptions the options for creating the pool
    # @overload pool(vertx,connectionUri,poolOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @param [Hash{String => Object}] poolOptions 
    # @overload pool(vertx,connectOptions,poolOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] connectOptions 
    #   @param [Hash{String => Object}] poolOptions 
    # @return [::VertxPgClient::PgPool]
    def self.pool(*args)
      if !block_given? && args[0] == nil && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, []).call(),::VertxPgClient::PgPool)
      elsif args[0].class == Hash && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxSqlclient::PoolOptions.java_class]).call(Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(args[0]))),::VertxPgClient::PgPool)
      elsif args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::java.lang.String.java_class]).call(args[0]),::VertxPgClient::PgPool)
      elsif args[0].class == String && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(args[0],Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxPgClient::PgPool)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxPgClient::PgPool)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(args[0].j_del,Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxPgClient::PgPool)
      elsif args[0].class == Hash && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxPgclient::PgConnectOptions.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(Java::IoVertxPgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[0])),Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxPgClient::PgPool)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(args[0].j_del,args[1],Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxPgClient::PgPool)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclient::PgPool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxPgclient::PgConnectOptions.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(args[0].j_del,Java::IoVertxPgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxPgClient::PgPool)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pool(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    # @overload preparedQuery(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @overload preparedQuery(sql,arguments,handler)
    #   @param [String] sql 
    #   @param [::VertxSqlClient::Tuple] arguments 
    #   @yield 
    # @return [self]
    def prepared_query(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepared_query(#{args[0]},#{args[1]})"
      end
    end
  end
end
