require 'vertx-redis/response'
require 'vertx/vertx'
require 'vertx-redis/redis_connection'
require 'vertx/future'
require 'vertx-redis/request'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.Redis
module VertxRedis
  #  A simple Redis client.
  class Redis
    # @private
    # @param j_del [::VertxRedis::Redis] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::Redis] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Redis
    end
    def @@j_api_type.wrap(obj)
      Redis.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::Redis.java_class
    end
    #  Create a new redis client using the given client options.
    # @overload createClient(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @overload createClient(vertx,connectionString)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [String] connectionString a string URI following the scheme: redis://[username:password@][host][:port][/database]
    # @overload createClient(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the user provided options
    # @return [::VertxRedis::Redis] the client
    def self.create_client(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Redis.java_method(:createClient, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxRedis::Redis)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Redis.java_method(:createClient, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxRedis::Redis)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Redis.java_method(:createClient, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxRedisClient::RedisOptions.java_class]).call(args[0].j_del,Java::IoVertxRedisClient::RedisOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxRedis::Redis)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_client(#{args[0]},#{args[1]})"
      end
    end
    #  Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
    #  client users.
    # @overload batch(commands,onSend)
    #   @param [Array<::VertxRedis::Request>] commands list of command to send
    #   @yield the asynchronous result handler.
    # @return [self]
    def batch(*args)
      if args[0].class == Array && true
        if (block_given?)
          @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxRedis::Response) } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxRedis::Response) } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling batch(#{args[0]})"
      end
    end
    #  Send the given command to the redis server or cluster.
    # @overload send(command,onSend)
    #   @param [::VertxRedis::Request] command the command to send
    #   @yield the asynchronous result handler.
    # @return [self]
    def send(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:send, [Java::IoVertxRedisClient::Request.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::IoVertxRedisClient::Request.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRedis::Response.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send(#{args[0]})"
      end
    end
    #  Closes the client and terminates any connection.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Connects to the redis server.
    # @overload connect(handler)
    #   @yield the async result handler
    # @return [self]
    def connect
      if true
        if (block_given?)
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::RedisConnection) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::RedisConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRedis::RedisConnection.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect()"
      end
    end
  end
end
