require 'vertx/pipe'
require 'vertx-redis/response'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx-redis/request'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.RedisConnection
module VertxRedis
  #  A simple Redis client.
  class RedisConnection
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxRedis::RedisConnection] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::RedisConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RedisConnection
    end
    def @@j_api_type.wrap(obj)
      RedisConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::RedisConnection.java_class
    end
    #  Flag to notify if the pending message queue (commands in transit) is full.
    # 
    #  When the pending message queue is full and a new send command is issued it will result in a exception to be thrown.
    #  Checking this flag before sending can allow the application to wait before sending the next message.
    # @overload pendingQueueFull()
    # @return [true,false] true is queue is full.
    def pending_queue_full?
      if !block_given?
        return @j_del.java_method(:pendingQueueFull, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pending_queue_full?()"
      end
    end
    #  
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    #  
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxRedis::Response)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    #  
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    #  
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    #  Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
    #  client users.
    # @overload batch(commands,onSend)
    #   @param [Array<::VertxRedis::Request>] commands list of command to send
    #   @yield the asynchronous result handler.
    # @return [self]
    def batch(*args)
      if args[0].class == Array && true
        if (block_given?)
          @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxRedis::Response) } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxRedis::Response) } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling batch(#{args[0]})"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::VertxRedis::Response.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    #  Closes the connection or returns to the pool.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Send the given command to the redis server or cluster.
    # @overload send(command,onSend)
    #   @param [::VertxRedis::Request] command the command to send
    #   @yield the asynchronous result handler.
    # @return [self]
    def send(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:send, [Java::IoVertxRedisClient::Request.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::IoVertxRedisClient::Request.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxRedis::Response.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send(#{args[0]})"
      end
    end
    #  
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
  end
end
