require 'vertx-mongo/mongo_client'
require 'vertx-service-discovery/service_discovery'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.servicediscovery.types.MongoDataSource
module VertxServiceDiscovery
  class MongoDataSource
    # @private
    # @param j_del [::VertxServiceDiscovery::MongoDataSource] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxServiceDiscovery::MongoDataSource] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MongoDataSource
    end
    def @@j_api_type.wrap(obj)
      MongoDataSource.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxServicediscoveryTypes::MongoDataSource.java_class
    end
    #  Convenient method that looks for a Mongo datasource source and provides the configured {::VertxMongo::MongoClient}. The
    #  async result is marked as failed is there are no matching services, or if the lookup fails.
    # @overload getMongoClient(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @yield The result handler
    # @overload getMongoClient(discovery,filter,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Proc] filter The filter
    #   @yield The result handler
    # @overload getMongoClient(discovery,filter,consumerConfiguration,resultHandler)
    #   @param [::VertxServiceDiscovery::ServiceDiscovery] discovery The service discovery instance
    #   @param [Hash{String => Object}] filter The filter, optional
    #   @param [Hash{String => Object}] consumerConfiguration the consumer configuration
    #   @yield the result handler
    # @return [void]
    def self.get_mongo_client(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && true && args[2] == nil
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::MongoDataSource.java_method(:getMongoClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::MongoDataSource.java_method(:getMongoClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMongo::MongoClient.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Proc && true && args[2] == nil
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::MongoDataSource.java_method(:getMongoClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::MongoDataSource.java_method(:getMongoClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(event != nil ? JSON.parse(event.toJson.encode) : nil) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMongo::MongoClient.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == Hash && true
        if (block_given?)
          return Java::IoVertxServicediscoveryTypes::MongoDataSource.java_method(:getMongoClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoClient) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxServicediscoveryTypes::MongoDataSource.java_method(:getMongoClient, [Java::IoVertxServicediscovery::ServiceDiscovery.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMongo::MongoClient) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxMongo::MongoClient.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_mongo_client(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Convenient method to create a record for a Mongo data source.
    # @overload createRecord(name,location,metadata)
    #   @param [String] name the service name
    #   @param [Hash{String => Object}] location the location of the service (e.g. url, port...)
    #   @param [Hash{String => Object}] metadata additional metadata
    # @return [Hash{String => Object}] the created record
    def self.create_record(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == Hash && !block_given?
        return Java::IoVertxServicediscoveryTypes::MongoDataSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2])) != nil ? JSON.parse(Java::IoVertxServicediscoveryTypes::MongoDataSource.java_method(:createRecord, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0],::Vertx::Util::Utils.to_json_object(args[1]),::Vertx::Util::Utils.to_json_object(args[2])).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_record(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Unknown type.
    def self.UNKNOWN
      Java::IoVertxServicediscoveryTypes::MongoDataSource.UNKNOWN
    end
    def self.TYPE
      Java::IoVertxServicediscoveryTypes::MongoDataSource.TYPE
    end
  end
end
