require 'vertx/promise'
require 'vertx/vertx'
require 'vertx-service-discovery/service_publisher'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.servicediscovery.spi.ServiceExporter
module VertxServiceDiscovery
  #  The service exporter allows integrate other discovery technologies with the Vert.x service discovery. It maps
  #  entries from another technology to a  and maps  to a publication in this other
  #  technology. The exporter is one side of a service discovery bridge.
  class ServiceExporter
    # @private
    # @param j_del [::VertxServiceDiscovery::ServiceExporter] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxServiceDiscovery::ServiceExporter] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ServiceExporter
    end
    def @@j_api_type.wrap(obj)
      ServiceExporter.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxServicediscoverySpi::ServiceExporter.java_class
    end
    #  Starts the exporter.
    # @overload init(vertx,publisher,configuration,future)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [::VertxServiceDiscovery::ServicePublisher] publisher the service discovery instance
    #   @param [Hash{String => Object}] configuration the bridge configuration if any
    #   @param [::Vertx::Promise] future a future on which the bridge must report the completion of the starting
    # @return [void]
    def init(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class == Hash && args[3].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:init, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxServicediscoverySpi::ServicePublisher.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Promise.java_class]).call(args[0].j_del,args[1].j_del,::Vertx::Util::Utils.to_json_object(args[2]),args[3].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling init(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Close the exporter
    # @overload close(closeHandler)
    #   @yield the handle to be notified when exporter is closed, may be <code>null</code>
    # @return [void]
    def close
      if true
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Notify an existing record has been removed
    # @overload onUnpublish(id)
    #   @param [String] id the record registration id
    # @return [void]
    def on_unpublish(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:onUnpublish, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling on_unpublish(#{args[0]})"
      end
    end
    #  Notify an existing record has been updated, the record's registration can be used to uniquely
    #  identify the record
    # @overload onUpdate(record)
    #   @param [Hash{String => Object}] record the record
    # @return [void]
    def on_update(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:onUpdate, [Java::IoVertxServicediscovery::Record.java_class]).call(Java::IoVertxServicediscovery::Record.new(::Vertx::Util::Utils.to_json_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling on_update(#{args[0]})"
      end
    end
    #  Notify a new record has been published, the record's registration can be used to uniquely
    #  identify the record
    # @overload onPublish(record)
    #   @param [Hash{String => Object}] record the record
    # @return [void]
    def on_publish(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:onPublish, [Java::IoVertxServicediscovery::Record.java_class]).call(Java::IoVertxServicediscovery::Record.new(::Vertx::Util::Utils.to_json_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling on_publish(#{args[0]})"
      end
    end
  end
end
