require 'vertx/vertx'
require 'vertx-stomp/stomp_server_connection'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.stomp.Destination
module VertxStomp
  #  Represents a STOMP destination.
  #  Depending on the implementation, the message delivery is different. Queue are sending message to only one
  #  subscribers, while topics are broadcasting the message to all subscribers.
  #  <p/>
  #  Implementations <strong>must</strong> be thread-safe.
  class Destination
    # @private
    # @param j_del [::VertxStomp::Destination] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxStomp::Destination] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Destination
    end
    def @@j_api_type.wrap(obj)
      Destination.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtStomp::Destination.java_class
    end
    #  Gets the number of subscriptions attached to the current {::VertxStomp::Destination}.
    # @overload numberOfSubscriptions()
    # @return [Fixnum] the number of subscriptions.
    def number_of_subscriptions
      if !block_given?
        return @j_del.java_method(:numberOfSubscriptions, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling number_of_subscriptions()"
      end
    end
    #  Dispatches the given frame.
    # @overload dispatch(connection,frame)
    #   @param [::VertxStomp::StompServerConnection] connection the connection
    #   @param [Hash{String => Object}] frame the frame
    # @return [self]
    def dispatch(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        @j_del.java_method(:dispatch, [Java::IoVertxExtStomp::StompServerConnection.java_class,Java::IoVertxExtStomp::Frame.java_class]).call(args[0].j_del,Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[1])))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling dispatch(#{args[0]},#{args[1]})"
      end
    end
    #  Gets all subscription ids for the given destination hold by the given client
    # @overload getSubscriptions(connection)
    #   @param [::VertxStomp::StompServerConnection] connection the connection (client)
    # @return [Array<String>] the list of subscription id, empty if none
    def get_subscriptions(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:getSubscriptions, [Java::IoVertxExtStomp::StompServerConnection.java_class]).call(args[0].j_del).to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_subscriptions(#{args[0]})"
      end
    end
    #  Handles a un-subscription request to the current {::VertxStomp::Destination}.
    # @overload unsubscribe(connection,frame)
    #   @param [::VertxStomp::StompServerConnection] connection the connection
    #   @param [Hash{String => Object}] frame the <code>UNSUBSCRIBE</code> frame
    # @return [true,false] <code>true</code> if the un-subscription has been handled, <code>false</code> otherwise.
    def unsubscribe?(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return @j_del.java_method(:unsubscribe, [Java::IoVertxExtStomp::StompServerConnection.java_class,Java::IoVertxExtStomp::Frame.java_class]).call(args[0].j_del,Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unsubscribe?(#{args[0]},#{args[1]})"
      end
    end
    #  Handles a subscription request to the current {::VertxStomp::Destination}.
    # @overload subscribe(connection,frame)
    #   @param [::VertxStomp::StompServerConnection] connection the connection
    #   @param [Hash{String => Object}] frame the <code>SUBSCRIBE</code> frame
    # @return [self]
    def subscribe(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        @j_del.java_method(:subscribe, [Java::IoVertxExtStomp::StompServerConnection.java_class,Java::IoVertxExtStomp::Frame.java_class]).call(args[0].j_del,Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[1])))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscribe(#{args[0]},#{args[1]})"
      end
    end
    #  Handles a <code>NACK</code> frame.
    # @overload nack(connection,frame)
    #   @param [::VertxStomp::StompServerConnection] connection the connection
    #   @param [Hash{String => Object}] frame the <code>NACK</code> frame
    # @return [true,false] <code>true</code> if the destination has handled the frame (meaning it has sent the message with id)
    def nack?(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return @j_del.java_method(:nack, [Java::IoVertxExtStomp::StompServerConnection.java_class,Java::IoVertxExtStomp::Frame.java_class]).call(args[0].j_del,Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling nack?(#{args[0]},#{args[1]})"
      end
    end
    #  Handles a <code>ACK</code> frame.
    # @overload ack(connection,frame)
    #   @param [::VertxStomp::StompServerConnection] connection the connection
    #   @param [Hash{String => Object}] frame the <code>ACK</code> frame
    # @return [true,false] <code>true</code> if the destination has handled the frame (meaning it has sent the message with id)
    def ack?(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return @j_del.java_method(:ack, [Java::IoVertxExtStomp::StompServerConnection.java_class,Java::IoVertxExtStomp::Frame.java_class]).call(args[0].j_del,Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ack?(#{args[0]},#{args[1]})"
      end
    end
    # @overload destination()
    # @return [String] the destination address.
    def destination
      if !block_given?
        return @j_del.java_method(:destination, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling destination()"
      end
    end
    # @overload topic(vertx,destination)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] destination 
    # @return [::VertxStomp::Destination]
    def self.topic(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::Destination.java_method(:topic, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxStomp::Destination)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling topic(#{args[0]},#{args[1]})"
      end
    end
    # @overload bridge(vertx,options)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] options 
    # @return [::VertxStomp::Destination]
    def self.bridge(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::Destination.java_method(:bridge, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtStomp::BridgeOptions.java_class]).call(args[0].j_del,Java::IoVertxExtStomp::BridgeOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxStomp::Destination)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling bridge(#{args[0]},#{args[1]})"
      end
    end
    #  Removes all subscriptions of the given connection
    # @overload unsubscribeConnection(connection)
    #   @param [::VertxStomp::StompServerConnection] connection the connection
    # @return [self]
    def unsubscribe_connection(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:unsubscribeConnection, [Java::IoVertxExtStomp::StompServerConnection.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unsubscribe_connection(#{args[0]})"
      end
    end
    #  Checks whether or not the given address matches with the current destination.
    # @overload matches(address)
    #   @param [String] address the address
    # @return [true,false] <code>true</code> if it matches, <code>false</code> otherwise.
    def matches?(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:matches, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling matches?(#{args[0]})"
      end
    end
    # @overload queue(vertx,destination)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] destination 
    # @return [::VertxStomp::Destination]
    def self.queue(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::Destination.java_method(:queue, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxStomp::Destination)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling queue(#{args[0]},#{args[1]})"
      end
    end
  end
end
