require 'vertx-stomp/stomp_client_connection'
require 'vertx/vertx'
require 'vertx/net_client'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.stomp.StompClient
module VertxStomp
  #  Defines a STOMP client.
  class StompClient
    # @private
    # @param j_del [::VertxStomp::StompClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxStomp::StompClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == StompClient
    end
    def @@j_api_type.wrap(obj)
      StompClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtStomp::StompClient.java_class
    end
    # @overload isClosed()
    # @return [true,false] whether or not the client is connected to the server.
    def closed?
      if !block_given?
        return @j_del.java_method(:isClosed, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling closed?()"
      end
    end
    #  Configures a received handler that gets notified when a STOMP frame is received by the client.
    #  This handler can be used for logging, debugging or ad-hoc behavior. The frame can still be modified at the time.
    #  <p>
    #  When a connection is created, the handler is used as
    #  {::VertxStomp::StompClientConnection#received_frame_handler}.
    # @overload receivedFrameHandler(handler)
    #   @yield the handler
    # @return [self]
    def received_frame_handler
      if true
        @j_del.java_method(:receivedFrameHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling received_frame_handler()"
      end
    end
    #  Configures a writing handler that gets notified when a STOMP frame is written on the wire.
    #  This handler can be used for logging, debugging or ad-hoc behavior. The frame can still be modified at the time.
    #  <p>
    #  When a connection is created, the handler is used as
    #  {::VertxStomp::StompClientConnection#writing_frame_handler}.
    # @overload writingFrameHandler(handler)
    #   @yield the handler
    # @return [self]
    def writing_frame_handler
      if true
        @j_del.java_method(:writingFrameHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling writing_frame_handler()"
      end
    end
    # @overload options()
    # @return [Hash{String => Object}] the client's options.
    def options
      if !block_given?
        return @j_del.java_method(:options, []).call() != nil ? JSON.parse(@j_del.java_method(:options, []).call().toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling options()"
      end
    end
    # @overload vertx()
    # @return [::Vertx::Vertx] the vert.x instance used by the client.
    def vertx
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:vertx, []).call(),::Vertx::Vertx)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling vertx()"
      end
    end
    #  Creates a {::VertxStomp::StompClient} using the default implementation.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the vert.x instance to use
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vert.x instance to use
    #   @param [Hash{String => Object}] options the options
    # @return [::VertxStomp::StompClient] the created {::VertxStomp::StompClient}
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::StompClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxStomp::StompClient)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::StompClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtStomp::StompClientOptions.java_class]).call(args[0].j_del,Java::IoVertxExtStomp::StompClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxStomp::StompClient)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  A general error frame handler. It can be used to catch <code>ERROR</code> frame emitted during the connection process
    #  (wrong authentication). This error handler will be pass to all {::VertxStomp::StompClientConnection} created from this
    #  client. Obviously, the client can override it when the connection is established.
    # @overload errorFrameHandler(handler)
    #   @yield the handler
    # @return [self]
    def error_frame_handler
      if true
        @j_del.java_method(:errorFrameHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling error_frame_handler()"
      end
    end
    #  Closes the client.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Sets an exception handler notified for TCP-level errors.
    # @overload exceptionHandler(handler)
    #   @yield the handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Connects to the server.
    # @overload connect(resultHandler)
    #   @yield handler called with the connection result. A failure will be sent to the handler if a TCP level issue happen before the `CONNECTED` frame is received. Afterwards, the {::VertxStomp::StompClient#exception_handler} is called.
    # @overload connect(net,resultHandler)
    #   @param [::Vertx::NetClient] net the NET client to use
    #   @yield handler called with the connection result
    # @overload connect(port,host,resultHandler)
    #   @param [Fixnum] port the server port
    #   @param [String] host the server host
    #   @yield handler called with the connection result
    # @overload connect(port,host,net,resultHandler)
    #   @param [Fixnum] port the server port
    #   @param [String] host the server host
    #   @param [::Vertx::NetClient] net the NET client to use
    #   @yield handler called with the connection result
    # @return [self]
    def connect(*args)
      if true && args[0] == nil && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompClientConnection) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompClientConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxStomp::StompClientConnection.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && true && args[1] == nil && args[2] == nil
        if (block_given?)
          @j_del.java_method(:connect, [Java::IoVertxCoreNet::NetClient.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompClientConnection) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::IoVertxCoreNet::NetClient.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompClientConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxStomp::StompClientConnection.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && true && args[2] == nil
        if (block_given?)
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompClientConnection) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompClientConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxStomp::StompClientConnection.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && args[2].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreNet::NetClient.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompClientConnection) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreNet::NetClient.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],args[2].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompClientConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxStomp::StompClientConnection.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
  end
end
