require 'vertx-unit/test_suite_report'
require 'vertx/vertx'
require 'vertx/message_consumer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.unit.collect.EventBusCollector
module VertxUnit
  #  The event bus collector listen to events on the Vert.x event bus and translate them
  #  into reports.
  class EventBusCollector
    # @private
    # @param j_del [::VertxUnit::EventBusCollector] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxUnit::EventBusCollector] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == EventBusCollector
    end
    def @@j_api_type.wrap(obj)
      EventBusCollector.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtUnitCollect::EventBusCollector.java_class
    end
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] options the reporting options
    # @overload create(vertx,reporter)
    #   @param [::Vertx::Vertx] vertx 
    #   @yield 
    # @return [::VertxUnit::EventBusCollector]
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtUnitCollect::EventBusCollector.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtUnitReport::ReportingOptions.java_class]).call(args[0].j_del,Java::IoVertxExtUnitReport::ReportingOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxUnit::EventBusCollector)
      elsif args[0].class.method_defined?(:j_del) && true && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtUnitCollect::EventBusCollector.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxUnit::TestSuiteReport)) unless !block_given? })),::VertxUnit::EventBusCollector)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Register the collector as a consumer of the event bus with the specified address.
    # @overload register(address)
    #   @param [String] address the registration address
    # @return [::Vertx::MessageConsumer] the subscribed message consumer
    def register(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:register, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::MessageConsumer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register(#{args[0]})"
      end
    end
    #  Json <code>type</code> field value that signals a test suite begins, used as part of the test reporting
    #  protocol for the event bus.
    def self.EVENT_TEST_SUITE_BEGIN
      Java::IoVertxExtUnitCollect::EventBusCollector.EVENT_TEST_SUITE_BEGIN
    end
    #  Json <code>type</code> field value that signals a test suite ends, used as part of the test reporting
    #  protocol for the event bus.
    def self.EVENT_TEST_SUITE_END
      Java::IoVertxExtUnitCollect::EventBusCollector.EVENT_TEST_SUITE_END
    end
    #  Json <code>type</code> field value that reports a test suite error, used as part of the test reporting
    #  protocol for the event bus.
    def self.EVENT_TEST_SUITE_ERROR
      Java::IoVertxExtUnitCollect::EventBusCollector.EVENT_TEST_SUITE_ERROR
    end
    #  Json <code>type</code> field value that signals a test case begins, used as part of the test reporting
    #  protocol for the event bus.
    def self.EVENT_TEST_CASE_BEGIN
      Java::IoVertxExtUnitCollect::EventBusCollector.EVENT_TEST_CASE_BEGIN
    end
    #  Json <code>type</code> field value that signals a test case ends, used as part of the test reporting
    #  protocol for the event bus.
    def self.EVENT_TEST_CASE_END
      Java::IoVertxExtUnitCollect::EventBusCollector.EVENT_TEST_CASE_END
    end
  end
end
