require 'vertx-auth-common/authorization'
require 'vertx-web/routing_context'
require 'vertx-auth-common/authorization_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.AuthorizationHandler
module VertxWeb
  #  Base interface for authorization handlers that provide authorization support.
  #  <p>
  #  AuthorizationHandlerImpl usually requires a {::VertxWeb::AuthenticationHandler} to be on the routing chain before it
  #  or a custom handler that has previously set a {::VertxAuthCommon::User} in the {::VertxWeb::RoutingContext}
  class AuthorizationHandler
    # @private
    # @param j_del [::VertxWeb::AuthorizationHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::AuthorizationHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AuthorizationHandler
    end
    def @@j_api_type.wrap(obj)
      AuthorizationHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::AuthorizationHandler.java_class
    end
    #  create the the handler that will check the specified authorization
    #  Note that to check several authorizations, you can specify a sub-interface such as {::VertxAuthCommon::AndAuthorization} or {::VertxAuthCommon::OrAuthorization}
    # @overload create(authorization)
    #   @param [::VertxAuthCommon::Authorization] authorization the authorization to attest.
    # @return [::VertxWeb::AuthorizationHandler] fluent self.
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::AuthorizationHandler.java_method(:create, [Java::IoVertxExtAuthAuthorization::Authorization.java_class]).call(args[0].j_del),::VertxWeb::AuthorizationHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Adds a provider that shall be used to retrieve the required authorizations for the user to attest.
    #  Multiple calls are allowed to retrieve authorizations from many sources.
    # @overload addAuthorizationProvider(authorizationProvider)
    #   @param [::VertxAuthCommon::AuthorizationProvider] authorizationProvider a provider.
    # @return [self]
    def add_authorization_provider(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addAuthorizationProvider, [Java::IoVertxExtAuthAuthorization::AuthorizationProvider.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_authorization_provider(#{args[0]})"
      end
    end
  end
end
