require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.MultiTenantHandler
module VertxWeb
  #  A handler which selectively executes another handler if a precondition is met.
  # 
  #  There are cases where applications are build as multi tenant, in this cases one of the
  #  common tasks is to configure different authentication mechanisms for each tenant.
  # 
  #  This handler will allow registering any other handler and will only execute it if
  #  the precondition is met. There are 2 way of defining a precondition:
  # 
  #  <ul>
  #      <li>A http header value for example <pre>X-Tenant</pre></li>
  #      <li>A custom extractor function that can return a String from the context</li>
  #  </ul>
  # 
  #  Requests that pass the validation will contain a new key in the routing context with
  #  the tenant id, for the case of being a default handler the value if this key will be "default".
  class MultiTenantHandler
    # @private
    # @param j_del [::VertxWeb::MultiTenantHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::MultiTenantHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MultiTenantHandler
    end
    def @@j_api_type.wrap(obj)
      MultiTenantHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::MultiTenantHandler.java_class
    end
    #  Add a handler for a given tenant to this handler.
    # 
    #  Both tenant and handler cannot be null.
    # @overload addTenantHandler(tenant,handler)
    #   @param [String] tenant the tenant id
    #   @yield the handler to register.
    # @return [self]
    def add_tenant_handler(*args)
      if args[0].class == String && true
        @j_del.java_method(:addTenantHandler, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_tenant_handler(#{args[0]})"
      end
    end
    #  Add a default handler for the case when no tenant was matched.
    # 
    #  The handler cannot be null.
    # @overload addDefaultHandler(handler)
    #   @yield the handler to register.
    # @return [self]
    def add_default_handler
      if true
        @j_del.java_method(:addDefaultHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_default_handler()"
      end
    end
    #  Create a MultiTenant handler using a custom tenant extraction function.
    # @overload create(header)
    #   @param [String] header the header to lookup (e.g.: "X-Tenant")
    # @overload create(tenantExtractor)
    #   @yield the function that extracts the tenant id from the request
    # @overload create(tenantExtractor,contextKey)
    #   @param [Proc] tenantExtractor the function that extracts the tenant id from the request
    #   @param [String] contextKey the custom key to store the tenant id in the context
    # @return [::VertxWeb::MultiTenantHandler] the new handler.
    def self.create(*args)
      if args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MultiTenantHandler.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::MultiTenantHandler)
      elsif block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MultiTenantHandler.java_method(:create, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless !block_given? })),::VertxWeb::MultiTenantHandler)
      elsif args[0].class == Proc && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MultiTenantHandler.java_method(:create, [Java::JavaUtilFunction::Function.java_class,Java::java.lang.String.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless args[0] == nil }),args[1]),::VertxWeb::MultiTenantHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Remove a handler for a given tenant from this handler.
    # 
    #  Tenant cannot be null.
    # @overload removeTenant(tenant)
    #   @param [String] tenant the tenant id
    # @return [self]
    def remove_tenant(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:removeTenant, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_tenant(#{args[0]})"
      end
    end
    #  The default key used to identify a tenant in the context data.
    def self.TENANT
      Java::IoVertxExtWebHandler::MultiTenantHandler.TENANT
    end
  end
end
