require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.shareddata.AsyncMap
module Vertx
  #  An asynchronous map.
  #  <p>
  #  {::Vertx::AsyncMap} does <em>not</em> allow <code>null</code> to be used as a key or value.
  class AsyncMap
    # @private
    # @param j_del [::Vertx::AsyncMap] the java delegate
    def initialize(j_del, j_arg_K=nil, j_arg_V=nil)
      @j_del = j_del
      @j_arg_K = j_arg_K != nil ? j_arg_K : ::Vertx::Util::unknown_type
      @j_arg_V = j_arg_V != nil ? j_arg_V : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::AsyncMap] the underlying java delegate
    def j_del
      @j_del
    end
    #  Replace the entry only if it is currently mapped to a specific value
    # @overload replaceIfPresent(k,oldValue,newValue,resultHandler)
    #   @param [Object] k the key
    #   @param [Object] oldValue the existing value
    #   @param [Object] newValue the new value
    #   @yield the result handler
    # @return [void]
    def replace_if_present(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && @j_arg_V.accept?(args[2]) && true
        if (block_given?)
          return @j_del.java_method(:replaceIfPresent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),@j_arg_V.unwrap(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:replaceIfPresent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),@j_arg_V.unwrap(args[2]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling replace_if_present(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Provide the number of entries in the map
    # @overload size(resultHandler)
    #   @yield handler which will receive the number of entries
    # @return [void]
    def size
      if true
        if (block_given?)
          return @j_del.java_method(:size, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:size, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    #  Get a value from the map, asynchronously.
    # @overload get(k,resultHandler)
    #   @param [Object] k the key
    #   @yield - this will be called some time later with the async result.
    # @return [void]
    def get(*args)
      if @j_arg_K.accept?(args[0]) && true
        if (block_given?)
          return @j_del.java_method(:get, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:get, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  Clear all entries in the map
    # @overload clear(resultHandler)
    #   @yield called on completion
    # @return [void]
    def clear
      if true
        if (block_given?)
          return @j_del.java_method(:clear, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:clear, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clear()"
      end
    end
    #  Replace the entry only if it is currently mapped to some value
    # @overload replace(k,v,resultHandler)
    #   @param [Object] k the key
    #   @param [Object] v the new value
    #   @yield the result handler will be passed the previous value
    # @return [void]
    def replace(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && true
        if (block_given?)
          return @j_del.java_method(:replace, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:replace, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling replace(#{args[0]},#{args[1]})"
      end
    end
    #  Link {::Vertx::AsyncMap#put_if_absent} but specifying a time to live for the entry. Entry will expire and get evicted
    #  after the ttl.
    # @overload putIfAbsent(k,v,completionHandler)
    #   @param [Object] k the key
    #   @param [Object] v the value
    #   @yield the handler
    # @overload putIfAbsent(k,v,ttl,completionHandler)
    #   @param [Object] k the key
    #   @param [Object] v the value
    #   @param [Fixnum] ttl The time to live (in ms) for the entry
    #   @yield the handler
    # @return [void]
    def put_if_absent(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && true && args[2] == nil
        if (block_given?)
          return @j_del.java_method(:putIfAbsent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:putIfAbsent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && args[2].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:putIfAbsent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:putIfAbsent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_if_absent(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Remove a value from the map, asynchronously.
    # @overload remove(k,resultHandler)
    #   @param [Object] k the key
    #   @yield - this will be called some time later to signify the value has been removed
    # @return [void]
    def remove(*args)
      if @j_arg_K.accept?(args[0]) && true
        if (block_given?)
          return @j_del.java_method(:remove, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:remove, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_V.wrap(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove(#{args[0]})"
      end
    end
    #  Like {::Vertx::AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
    #  ttl.
    # @overload put(k,v,completionHandler)
    #   @param [Object] k the key
    #   @param [Object] v the value
    #   @yield - this will be called some time later to signify the value has been put
    # @overload put(k,v,ttl,completionHandler)
    #   @param [Object] k the key
    #   @param [Object] v the value
    #   @param [Fixnum] ttl The time to live (in ms) for the entry
    #   @yield the handler
    # @return [void]
    def put(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && true && args[2] == nil
        if (block_given?)
          return @j_del.java_method(:put, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:put, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && args[2].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:put, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:put, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),args[2],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Remove a value from the map, only if entry already exists with same value.
    # @overload removeIfPresent(k,v,resultHandler)
    #   @param [Object] k the key
    #   @param [Object] v the value
    #   @yield - this will be called some time later to signify the value has been removed
    # @return [void]
    def remove_if_present(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && true
        if (block_given?)
          return @j_del.java_method(:removeIfPresent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:removeIfPresent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_if_present(#{args[0]},#{args[1]})"
      end
    end
  end
end
